/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundLoginDisconnectPacket;
import java.util.List;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.geysermc.relocate.kyori.adventure.text.TextComponent;
import org.geysermc.relocate.kyori.adventure.text.TranslatableComponent;

@Translator(packet=ClientboundLoginDisconnectPacket.class)
public class JavaLoginDisconnectTranslator
extends PacketTranslator<ClientboundLoginDisconnectPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLoginDisconnectPacket packet) {
        Object disconnectMessage;
        Component disconnectReason = packet.getReason();
        String serverDisconnectMessage = MessageTranslator.convertMessage(disconnectReason, session.locale());
        if (this.testForOutdatedServer(disconnectReason)) {
            String locale = session.locale();
            PlatformType platform = session.getGeyser().getPlatformType();
            String outdatedType = platform == PlatformType.BUNGEECORD || platform == PlatformType.VELOCITY ? "geyser.network.remote.outdated.proxy" : "geyser.network.remote.outdated.server";
            disconnectMessage = GeyserLocale.getPlayerLocaleString(outdatedType, locale, GameProtocol.getJavaVersions().get(0)) + "\n" + GeyserLocale.getPlayerLocaleString("geyser.network.remote.original_disconnect_message", locale, serverDisconnectMessage);
        } else {
            disconnectMessage = this.testForMissingProfilePublicKey(disconnectReason) ? "Please set `enforce-secure-profile` to `false` in server.properties for Bedrock players to be able to connect.\n" + GeyserLocale.getPlayerLocaleString("geyser.network.remote.original_disconnect_message", session.locale(), serverDisconnectMessage) : serverDisconnectMessage;
        }
        session.disconnect((String)disconnectMessage);
    }

    private boolean testForOutdatedServer(Component disconnectReason) {
        if (disconnectReason instanceof TranslatableComponent) {
            TranslatableComponent component = (TranslatableComponent)disconnectReason;
            String key = component.key();
            return "multiplayer.disconnect.incompatible".equals(key) || "multiplayer.disconnect.outdated_client".equals(key) || "multiplayer.disconnect.outdated_server".equals(key) || key.startsWith("Outdated server!");
        }
        if (disconnectReason instanceof TextComponent) {
            TextComponent component = (TextComponent)disconnectReason;
            if (component.content().startsWith("Outdated server!")) {
                return true;
            }
            List<Component> children = component.children();
            for (Component value : children) {
                TextComponent child;
                if (!(value instanceof TextComponent) || !(child = (TextComponent)value).content().startsWith("Outdated server!")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean testForMissingProfilePublicKey(Component disconnectReason) {
        TranslatableComponent component;
        return disconnectReason instanceof TranslatableComponent && "multiplayer.disconnect.missing_public_key".equals((component = (TranslatableComponent)disconnectReason).key());
    }

    @Override
    public boolean shouldExecuteInEventLoop() {
        return false;
    }
}

