/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundRecipePacket;
import java.util.ArrayList;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.packet.UnlockedRecipesPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundRecipePacket.class)
public class JavaClientboundRecipesTranslator
extends PacketTranslator<ClientboundRecipePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundRecipePacket packet) {
        UnlockedRecipesPacket recipesPacket = new UnlockedRecipesPacket();
        switch (packet.getAction()) {
            case INIT: {
                recipesPacket.setAction(UnlockedRecipesPacket.ActionType.INITIALLY_UNLOCKED);
                recipesPacket.getUnlockedRecipes().addAll(this.getBedrockRecipes(session, packet.getAlreadyKnownRecipes()));
                break;
            }
            case ADD: {
                recipesPacket.setAction(UnlockedRecipesPacket.ActionType.NEWLY_UNLOCKED);
                recipesPacket.getUnlockedRecipes().addAll(this.getBedrockRecipes(session, packet.getRecipes()));
                break;
            }
            case REMOVE: {
                recipesPacket.setAction(UnlockedRecipesPacket.ActionType.REMOVE_UNLOCKED);
                recipesPacket.getUnlockedRecipes().addAll(this.getBedrockRecipes(session, packet.getRecipes()));
            }
        }
        session.sendUpstreamPacket(recipesPacket);
    }

    private List<String> getBedrockRecipes(GeyserSession session, String[] javaRecipeIdentifiers) {
        ArrayList<String> recipes = new ArrayList<String>();
        for (String javaIdentifier : javaRecipeIdentifiers) {
            List<String> bedrockRecipes = session.getJavaToBedrockRecipeIds().get(javaIdentifier);
            if (bedrockRecipes == null) continue;
            recipes.addAll(bedrockRecipes);
        }
        return recipes;
    }
}

