/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;

@BlockEntity(type={BlockEntityType.BRUSHABLE_BLOCK})
public class BrushableBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(NbtMapBuilder builder, CompoundTag tag, int blockState) {
        Object t = tag.remove("item");
        if (!(t instanceof CompoundTag)) {
            return;
        }
        CompoundTag itemTag = (CompoundTag)t;
        Object hitDirection = tag.get("hit_direction");
        if (hitDirection == null) {
            return;
        }
        String id = ((StringTag)itemTag.get("id")).getValue();
        if (Items.AIR.javaIdentifier().equals(id)) {
            return;
        }
        ItemMapping mapping = Registries.ITEMS.forVersion(GameProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).getMapping(id);
        if (mapping == null) {
            return;
        }
        NbtMapBuilder itemBuilder = NbtMap.builder().putString("Name", mapping.getBedrockIdentifier()).putByte("Count", (Byte)((Tag)itemTag.get("Count")).getValue());
        builder.putCompound("item", itemBuilder.build());
        builder.putByte("brush_direction", ((Number)((Tag)hitDirection).getValue()).byteValue());
        builder.putInt("brush_count", BlockStateValues.getBrushProgress(blockState));
    }
}

