/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;

public class ShulkerInventoryTranslator
extends AbstractBlockInventoryTranslator {
    public ShulkerInventoryTranslator() {
        super(27, new BlockInventoryHolder("minecraft:shulker_box[facing=north]", ContainerType.CONTAINER, new String[0]){
            private final BlockEntityTranslator shulkerBoxTranslator = (BlockEntityTranslator)Registries.BLOCK_ENTITIES.get(BlockEntityType.SHULKER_BOX);

            @Override
            protected boolean isValidBlock(String[] javaBlockString) {
                return javaBlockString[0].contains("shulker_box");
            }

            @Override
            protected void setCustomName(GeyserSession session, Vector3i position, Inventory inventory, int javaBlockState) {
                NbtMapBuilder tag = NbtMap.builder().putInt("x", position.getX()).putInt("y", position.getY()).putInt("z", position.getZ()).putString("CustomName", inventory.getTitle());
                this.shulkerBoxTranslator.translateTag(tag, null, javaBlockState);
                BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
                dataPacket.setData(tag.build());
                dataPacket.setBlockPosition(position);
                session.sendUpstreamPacket(dataPacket);
            }
        }, ContainerInventoryUpdater.INSTANCE);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int javaSlot) {
        if (javaSlot < this.size) {
            return new BedrockContainerSlot(ContainerSlotType.SHULKER_BOX, javaSlot);
        }
        return super.javaSlotToBedrockContainer(javaSlot);
    }
}

