/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.cloudburstmc.protocol.bedrock.data.skin.ImageData;
import org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.cloudburstmc.protocol.bedrock.packet.PlayerSkinPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;

public class SkullSkinManager
extends SkinManager {
    public static SerializedSkin buildSkullEntryManually(String skinId, byte[] skinData) {
        skinId = (String)skinId + "_skull";
        return SerializedSkin.of((String)skinId, "", SkinProvider.SKULL_GEOMETRY.geometryName(), ImageData.of(skinData), Collections.emptyList(), ImageData.of(SkinProvider.EMPTY_CAPE.capeData()), SkinProvider.SKULL_GEOMETRY.geometryData(), "", true, false, false, SkinProvider.EMPTY_CAPE.capeId(), (String)skinId);
    }

    public static void requestAndHandleSkin(SkullPlayerEntity entity, GeyserSession session, Consumer<SkinProvider.Skin> skinConsumer) {
        BiConsumer<SkinProvider.Skin, Throwable> applySkin = (skin, throwable) -> {
            try {
                PlayerSkinPacket packet = new PlayerSkinPacket();
                packet.setUuid(entity.getUuid());
                packet.setOldSkinName("");
                packet.setNewSkinName(skin.getTextureUrl());
                packet.setSkin(SkullSkinManager.buildSkullEntryManually(skin.getTextureUrl(), skin.getSkinData()));
                packet.setTrustedSkin(true);
                session.sendUpstreamPacket(packet);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), e);
            }
            if (skinConsumer != null) {
                skinConsumer.accept((SkinProvider.Skin)skin);
            }
        };
        SkinManager.GameProfileData data = SkinManager.GameProfileData.from(entity);
        if (data == null) {
            GeyserImpl.getInstance().getLogger().debug("Using fallback skin for skull at " + entity.getSkullPosition() + " with texture value: " + entity.getTexturesProperty() + " and UUID: " + entity.getSkullUUID());
            SkinProvider.SkinData fallback = SkinProvider.determineFallbackSkinData(entity.getSkullUUID());
            applySkin.accept(fallback.skin(), null);
        } else {
            SkinProvider.requestSkin(entity.getUuid(), data.skinUrl(), true).whenCompleteAsync((BiConsumer)applySkin);
        }
    }
}

