/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;

public class SkullCache {
    private final int maxVisibleSkulls;
    private final boolean cullingEnabled;
    private final int skullRenderDistanceSquared;
    private static final long CLEANUP_PERIOD = 10000L;
    private final Map<Vector3i, Skull> skulls = new Object2ObjectOpenHashMap();
    private final List<Skull> inRangeSkulls = new ArrayList<Skull>();
    private final Deque<SkullPlayerEntity> unusedSkullEntities = new ArrayDeque<SkullPlayerEntity>();
    private int totalSkullEntities = 0;
    private final GeyserSession session;
    private Vector3f lastPlayerPosition;
    private long lastCleanup = System.currentTimeMillis();

    public SkullCache(GeyserSession session) {
        this.session = session;
        this.maxVisibleSkulls = session.getGeyser().getConfig().getMaxVisibleCustomSkulls();
        this.cullingEnabled = this.maxVisibleSkulls != -1;
        int distance = Math.min(session.getGeyser().getConfig().getCustomSkullRenderDistance(), 64);
        this.skullRenderDistanceSquared = distance * distance;
    }

    public Skull putSkull(Vector3i position, UUID uuid, String texturesProperty, int blockState) {
        Skull skull;
        block14: {
            skull = this.skulls.computeIfAbsent(position, Skull::new);
            skull.uuid = uuid;
            if (!texturesProperty.equals(skull.texturesProperty)) {
                skull.texturesProperty = texturesProperty;
                skull.skinHash = null;
                try {
                    SkinManager.GameProfileData gameProfileData = SkinManager.GameProfileData.loadFromJson(texturesProperty);
                    if (gameProfileData != null && gameProfileData.skinUrl() != null) {
                        String skinUrl = gameProfileData.skinUrl();
                        skull.skinHash = skinUrl.substring(skinUrl.lastIndexOf(47) + 1);
                    } else {
                        this.session.getGeyser().getLogger().debug("Player skull with invalid Skin tag: " + position + " Textures: " + texturesProperty);
                    }
                }
                catch (IOException e) {
                    this.session.getGeyser().getLogger().debug("Player skull with invalid Skin tag: " + position + " Textures: " + texturesProperty);
                    if (!GeyserImpl.getInstance().getConfig().isDebugMode()) break block14;
                    e.printStackTrace();
                }
            }
        }
        skull.blockState = blockState;
        skull.blockDefinition = this.translateCustomSkull(skull.skinHash, blockState);
        if (skull.blockDefinition != null) {
            this.reassignSkullEntity(skull);
            return skull;
        }
        if (skull.entity != null) {
            skull.entity.updateSkull(skull);
        } else {
            if (!this.cullingEnabled) {
                this.assignSkullEntity(skull);
                return skull;
            }
            if (this.lastPlayerPosition == null) {
                return skull;
            }
            skull.distanceSquared = position.distanceSquared(this.lastPlayerPosition.getX(), this.lastPlayerPosition.getY(), this.lastPlayerPosition.getZ());
            if (skull.distanceSquared < this.skullRenderDistanceSquared) {
                int i = Collections.binarySearch(this.inRangeSkulls, skull, Comparator.comparingInt(Skull::getDistanceSquared));
                if (i < 0) {
                    i = -i - 1;
                }
                this.inRangeSkulls.add(i, skull);
                if (i < this.maxVisibleSkulls) {
                    if (this.inRangeSkulls.size() > this.maxVisibleSkulls) {
                        this.freeSkullEntity(this.inRangeSkulls.get(this.maxVisibleSkulls));
                    }
                    this.assignSkullEntity(skull);
                }
            }
        }
        return skull;
    }

    public void removeSkull(Vector3i position) {
        Skull skull = this.skulls.remove(position);
        if (skull != null) {
            this.reassignSkullEntity(skull);
        }
    }

    public Skull updateSkull(Vector3i position, int blockState) {
        Skull skull = this.skulls.get(position);
        if (skull != null) {
            this.putSkull(position, skull.uuid, skull.texturesProperty, blockState);
        }
        return skull;
    }

    public void updateVisibleSkulls() {
        if (this.cullingEnabled) {
            if (this.lastPlayerPosition != null && this.session.getPlayerEntity().getPosition().distanceSquared(this.lastPlayerPosition) < 4.0f) {
                return;
            }
            this.lastPlayerPosition = this.session.getPlayerEntity().getPosition();
            this.inRangeSkulls.clear();
            for (Skull skull : this.skulls.values()) {
                if (skull.blockDefinition != null) continue;
                skull.distanceSquared = skull.position.distanceSquared(this.lastPlayerPosition.getX(), this.lastPlayerPosition.getY(), this.lastPlayerPosition.getZ());
                if (skull.distanceSquared > this.skullRenderDistanceSquared) {
                    this.freeSkullEntity(skull);
                    continue;
                }
                this.inRangeSkulls.add(skull);
            }
            this.inRangeSkulls.sort(Comparator.comparingInt(Skull::getDistanceSquared));
            for (int i = this.inRangeSkulls.size() - 1; i >= 0; --i) {
                if (i < this.maxVisibleSkulls) {
                    this.assignSkullEntity(this.inRangeSkulls.get(i));
                    continue;
                }
                this.freeSkullEntity(this.inRangeSkulls.get(i));
            }
        }
        if (System.currentTimeMillis() - this.lastCleanup > 10000L) {
            this.lastCleanup = System.currentTimeMillis();
            for (SkullPlayerEntity entity : this.unusedSkullEntities) {
                entity.despawnEntity();
                --this.totalSkullEntities;
            }
            this.unusedSkullEntities.clear();
        }
    }

    private void assignSkullEntity(Skull skull) {
        if (skull.entity != null) {
            return;
        }
        if (this.unusedSkullEntities.isEmpty()) {
            if (!this.cullingEnabled || this.totalSkullEntities < this.maxVisibleSkulls) {
                long geyserId = this.session.getEntityCache().getNextEntityId().incrementAndGet();
                skull.entity = new SkullPlayerEntity(this.session, geyserId);
                skull.entity.spawnEntity();
                skull.entity.updateSkull(skull);
                ++this.totalSkullEntities;
            }
        } else {
            skull.entity = this.unusedSkullEntities.removeFirst();
            skull.entity.updateSkull(skull);
        }
    }

    private void freeSkullEntity(Skull skull) {
        if (skull.entity != null) {
            skull.entity.free();
            this.unusedSkullEntities.addFirst(skull.entity);
            skull.entity = null;
        }
    }

    private void reassignSkullEntity(Skull skull) {
        boolean hadEntity = skull.entity != null;
        this.freeSkullEntity(skull);
        if (this.cullingEnabled) {
            this.inRangeSkulls.remove(skull);
            if (hadEntity && this.inRangeSkulls.size() >= this.maxVisibleSkulls) {
                this.assignSkullEntity(this.inRangeSkulls.get(this.maxVisibleSkulls - 1));
            }
        }
    }

    public void clear() {
        this.skulls.clear();
        this.inRangeSkulls.clear();
        this.unusedSkullEntities.clear();
        this.totalSkullEntities = 0;
        this.lastPlayerPosition = null;
    }

    private @Nullable BlockDefinition translateCustomSkull(String skinHash, int blockState) {
        CustomSkull customSkull = (CustomSkull)BlockRegistries.CUSTOM_SKULLS.get(skinHash);
        if (customSkull != null) {
            CustomBlockState customBlockState;
            byte floorRotation = BlockStateValues.getSkullRotation(blockState);
            if (floorRotation == -1) {
                int wallDirection = BlockStateValues.getSkullWallDirections().get(blockState);
                customBlockState = customSkull.getWallBlockState(wallDirection);
            } else {
                customBlockState = customSkull.getFloorBlockState(floorRotation);
            }
            return (BlockDefinition)this.session.getBlockMappings().getCustomBlockStateDefinitions().get((Object)customBlockState);
        }
        return null;
    }

    public Map<Vector3i, Skull> getSkulls() {
        return this.skulls;
    }

    public static class Skull {
        private UUID uuid;
        private String texturesProperty;
        private String skinHash;
        private int blockState;
        private BlockDefinition blockDefinition;
        private SkullPlayerEntity entity;
        private final Vector3i position;
        private int distanceSquared;

        public Skull(Vector3i position) {
            this.position = position;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getTexturesProperty() {
            return this.texturesProperty;
        }

        public String getSkinHash() {
            return this.skinHash;
        }

        public int getBlockState() {
            return this.blockState;
        }

        public BlockDefinition getBlockDefinition() {
            return this.blockDefinition;
        }

        public SkullPlayerEntity getEntity() {
            return this.entity;
        }

        public Vector3i getPosition() {
            return this.position;
        }

        public int getDistanceSquared() {
            return this.distanceSquared;
        }

        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        public void setTexturesProperty(String texturesProperty) {
            this.texturesProperty = texturesProperty;
        }

        public void setSkinHash(String skinHash) {
            this.skinHash = skinHash;
        }

        public void setBlockState(int blockState) {
            this.blockState = blockState;
        }

        public void setBlockDefinition(BlockDefinition blockDefinition) {
            this.blockDefinition = blockDefinition;
        }

        public void setEntity(SkullPlayerEntity entity) {
            this.entity = entity;
        }

        public void setDistanceSquared(int distanceSquared) {
            this.distanceSquared = distanceSquared;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Skull)) {
                return false;
            }
            Skull other = (Skull)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBlockState() != other.getBlockState()) {
                return false;
            }
            if (this.getDistanceSquared() != other.getDistanceSquared()) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$texturesProperty = this.getTexturesProperty();
            String other$texturesProperty = other.getTexturesProperty();
            if (this$texturesProperty == null ? other$texturesProperty != null : !this$texturesProperty.equals(other$texturesProperty)) {
                return false;
            }
            String this$skinHash = this.getSkinHash();
            String other$skinHash = other.getSkinHash();
            if (this$skinHash == null ? other$skinHash != null : !this$skinHash.equals(other$skinHash)) {
                return false;
            }
            BlockDefinition this$blockDefinition = this.getBlockDefinition();
            BlockDefinition other$blockDefinition = other.getBlockDefinition();
            if (this$blockDefinition == null ? other$blockDefinition != null : !this$blockDefinition.equals(other$blockDefinition)) {
                return false;
            }
            SkullPlayerEntity this$entity = this.getEntity();
            SkullPlayerEntity other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            Vector3i this$position = this.getPosition();
            Vector3i other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !this$position.equals(other$position));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Skull;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBlockState();
            result = result * 59 + this.getDistanceSquared();
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $texturesProperty = this.getTexturesProperty();
            result = result * 59 + ($texturesProperty == null ? 43 : $texturesProperty.hashCode());
            String $skinHash = this.getSkinHash();
            result = result * 59 + ($skinHash == null ? 43 : $skinHash.hashCode());
            BlockDefinition $blockDefinition = this.getBlockDefinition();
            result = result * 59 + ($blockDefinition == null ? 43 : $blockDefinition.hashCode());
            SkullPlayerEntity $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            Vector3i $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            return result;
        }

        public String toString() {
            return "SkullCache.Skull(uuid=" + this.getUuid() + ", texturesProperty=" + this.getTexturesProperty() + ", skinHash=" + this.getSkinHash() + ", blockState=" + this.getBlockState() + ", blockDefinition=" + this.getBlockDefinition() + ", entity=" + this.getEntity() + ", position=" + this.getPosition() + ", distanceSquared=" + this.getDistanceSquared() + ")";
        }
    }
}

