/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.codec.v622.Bedrock_v622;
import org.cloudburstmc.protocol.bedrock.codec.v630.Bedrock_v630;
import org.cloudburstmc.protocol.bedrock.codec.v649.Bedrock_v649;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ComponentItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.common.Definition;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.NonVanillaCustomBlockData;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.item.custom.NonVanillaCustomItemData;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.item.GeyserCustomMappingData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.populator.Conversion630_622;
import org.geysermc.geyser.registry.populator.Conversion630_649;
import org.geysermc.geyser.registry.populator.CreativeItemRegistryPopulator;
import org.geysermc.geyser.registry.populator.CustomItemRegistryPopulator;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.registry.type.NonVanillaItemRegistration;
import org.geysermc.geyser.registry.type.PaletteItem;
import org.geysermc.relocate.jackson.core.type.TypeReference;

public class ItemRegistryPopulator {
    public static void populate() {
        ObjectArrayList<NonVanillaCustomItemData> nonVanillaCustomItems;
        Map<String, GeyserMappingItem> items;
        ArrayList<PaletteVersion> paletteVersions = new ArrayList<PaletteVersion>(3);
        paletteVersions.add(new PaletteVersion("1_20_40", Bedrock_v622.CODEC.getProtocolVersion(), Collections.emptyMap(), Conversion630_622::remapItem));
        paletteVersions.add(new PaletteVersion("1_20_50", Bedrock_v630.CODEC.getProtocolVersion()));
        paletteVersions.add(new PaletteVersion("1_20_60", Bedrock_v649.CODEC.getProtocolVersion(), Collections.emptyMap(), Conversion630_649::remapItem));
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        TypeReference<Map<String, GeyserMappingItem>> mappingItemsType = new TypeReference<Map<String, GeyserMappingItem>>(){};
        try (InputStream stream = bootstrap.getResourceOrThrow("mappings/items.json");){
            items = GeyserImpl.JSON_MAPPER.readValue(stream, mappingItemsType);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java runtime item IDs", e);
        }
        boolean customItemsAllowed = GeyserImpl.getInstance().getConfig().isAddNonBedrockItems();
        ListMultimap customItems = MultimapBuilder.hashKeys().arrayListValues().build();
        ObjectArrayList<NonVanillaCustomItemData> objectArrayList = nonVanillaCustomItems = customItemsAllowed ? new ObjectArrayList<NonVanillaCustomItemData>() : Collections.emptyList();
        if (customItemsAllowed) {
            CustomItemRegistryPopulator.populate(items, (Multimap<String, CustomItemData>)customItems, nonVanillaCustomItems);
        }
        boolean firstMappingsPass = true;
        for (PaletteVersion palette : paletteVersions) {
            List<PaletteItem> itemEntries;
            TypeReference<List<PaletteItem>> paletteEntriesType = new TypeReference<List<PaletteItem>>(){};
            try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/runtime_item_states.%s.json", palette.version()));){
                itemEntries = GeyserImpl.JSON_MAPPER.readValue(stream, paletteEntriesType);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load Bedrock runtime item IDs", e);
            }
            int nextFreeBedrockId = 0;
            ObjectArrayList<ComponentItemData> componentItemData = new ObjectArrayList<ComponentItemData>();
            Int2ObjectOpenHashMap<ItemDefinition> registry = new Int2ObjectOpenHashMap<ItemDefinition>();
            Object2ObjectLinkedOpenHashMap definitions = new Object2ObjectLinkedOpenHashMap();
            for (PaletteItem entry : itemEntries) {
                int id = entry.getId();
                if (id >= nextFreeBedrockId) {
                    nextFreeBedrockId = id + 1;
                }
                SimpleItemDefinition definition = new SimpleItemDefinition(entry.getName().intern(), id, false);
                definitions.put(entry.getName(), definition);
                registry.put(definition.getRuntimeId(), (ItemDefinition)definition);
            }
            Object2ObjectOpenHashMap bedrockBlockIdOverrides = new Object2ObjectOpenHashMap();
            Object2IntOpenHashMap blacklistedIdentifiers = new Object2IntOpenHashMap();
            Object2ObjectOpenHashMap customBlockItemDefinitions = new Object2ObjectOpenHashMap();
            ObjectArrayList<ItemDefinition> buckets = new ObjectArrayList<ItemDefinition>();
            ObjectArrayList<ItemData> carpets = new ObjectArrayList<ItemData>();
            ObjectArrayList mappings = new ObjectArrayList();
            Object2ObjectOpenHashMap javaItemToMapping = new Object2ObjectOpenHashMap();
            ArrayList<ItemData> creativeItems = new ArrayList<ItemData>();
            AtomicInteger creativeNetId = new AtomicInteger();
            CreativeItemRegistryPopulator.populate(palette, (Map<String, ItemDefinition>)definitions, arg_0 -> ItemRegistryPopulator.lambda$populate$0(creativeNetId, creativeItems, blacklistedIdentifiers, (Object2ObjectMap)bedrockBlockIdOverrides, arg_0));
            BlockMappings blockMappings = BlockRegistries.BLOCKS.forVersion(palette.protocolVersion());
            ObjectOpenHashSet<Item> javaOnlyItems = new ObjectOpenHashSet<Item>();
            Collections.addAll(javaOnlyItems, Items.SPECTRAL_ARROW, Items.DEBUG_STICK, Items.KNOWLEDGE_BOOK, Items.TIPPED_ARROW, Items.BUNDLE);
            if (!customItemsAllowed) {
                javaOnlyItems.add(Items.FURNACE_MINECART);
            }
            javaOnlyItems.addAll(palette.javaOnlyItems().keySet());
            Int2ObjectOpenHashMap<String> customIdMappings = new Int2ObjectOpenHashMap<String>();
            ObjectOpenHashSet registeredItemNames = new ObjectOpenHashSet();
            for (Map.Entry<String, GeyserMappingItem> entry : items.entrySet()) {
                List<Pair<CustomItemOptions, ItemDefinition>> customItemOptions;
                Item javaItem = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get(entry.getKey());
                if (javaItem == null) {
                    throw new RuntimeException("Extra item in mappings? " + entry.getKey());
                }
                String replacementItem = palette.javaOnlyItems().get(javaItem);
                GeyserMappingItem mappingItem = replacementItem != null ? items.get(replacementItem) : palette.remapper().remap(javaItem, entry.getValue());
                if (customItemsAllowed && javaItem == Items.FURNACE_MINECART) {
                    mappings.add(null);
                    continue;
                }
                String bedrockIdentifier = mappingItem.getBedrockIdentifier();
                ItemDefinition definition = (ItemDefinition)definitions.get(bedrockIdentifier);
                if (definition == null) {
                    throw new RuntimeException("Missing Bedrock ItemDefinition in version " + palette.version() + " for mapping: " + mappingItem);
                }
                Object bedrockBlock = null;
                Integer firstBlockRuntimeId = entry.getValue().getFirstBlockRuntimeId();
                Definition customBlockItemOverride = null;
                if (firstBlockRuntimeId != null) {
                    BlockDefinition blockOverride = (BlockDefinition)bedrockBlockIdOverrides.get((Object)bedrockIdentifier);
                    CustomBlockData customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(javaItem.javaIdentifier(), null);
                    if (customBlockData != null && customBlockData.includedInCreativeInventory()) {
                        CustomBlockState customBlockState = customBlockData.defaultBlockState();
                        customBlockItemOverride = (BlockDefinition)blockMappings.getCustomBlockStateDefinitions().getOrDefault((Object)customBlockState, null);
                    }
                    if (blockOverride != null && customBlockItemOverride == null) {
                        bedrockBlock = blockOverride;
                    } else {
                        int aValidBedrockBlockId = blacklistedIdentifiers.getOrDefault((Object)bedrockIdentifier, customBlockItemOverride != null ? customBlockItemOverride.getRuntimeId() : -1);
                        if (aValidBedrockBlockId == -1 && customBlockItemOverride == null) {
                            bedrockBlock = blockMappings.getBedrockBlock(firstBlockRuntimeId);
                        } else {
                            Object blockTag;
                            NbtMapBuilder requiredBlockStatesBuilder = NbtMap.builder();
                            String correctBedrockIdentifier = blockMappings.getDefinition(aValidBedrockBlockId).getState().getString("name");
                            boolean firstPass = true;
                            Integer lastBlockRuntimeId = entry.getValue().getLastBlockRuntimeId() == null ? firstBlockRuntimeId : entry.getValue().getLastBlockRuntimeId();
                            for (int i = firstBlockRuntimeId.intValue(); i <= lastBlockRuntimeId; ++i) {
                                GeyserBedrockBlock[] bedrockBlockRuntimeId = blockMappings.getVanillaBedrockBlock(i);
                                NbtMap blockTag2 = bedrockBlockRuntimeId.getState();
                                String bedrockName = blockTag2.getString("name");
                                if (!bedrockName.equals(correctBedrockIdentifier)) continue;
                                NbtMap states = blockTag2.getCompound("states");
                                if (firstPass) {
                                    firstPass = false;
                                    if (states.isEmpty()) {
                                        bedrockBlock = bedrockBlockRuntimeId;
                                        break;
                                    }
                                    requiredBlockStatesBuilder.putAll(states);
                                    continue;
                                }
                                for (Map.Entry<String, Object> entry2 : states.entrySet()) {
                                    Object value = requiredBlockStatesBuilder.get(entry2.getKey());
                                    if (value == null || entry2.getValue().equals(value)) continue;
                                    requiredBlockStatesBuilder.remove(entry2.getKey());
                                }
                                if (requiredBlockStatesBuilder.isEmpty()) break;
                            }
                            NbtMap requiredBlockStates = requiredBlockStatesBuilder.build();
                            if (bedrockBlock == null) {
                                for (GeyserBedrockBlock block : blockMappings.getBedrockRuntimeMap()) {
                                    if (block == null || !((NbtMap)(blockTag = block.getState())).getString("name").equals(correctBedrockIdentifier)) continue;
                                    NbtMap nbtMap = ((NbtMap)blockTag).getCompound("states");
                                    boolean valid = true;
                                    for (Map.Entry<String, Object> nbtEntry : requiredBlockStates.entrySet()) {
                                        if (nbtMap.get(nbtEntry.getKey()).equals(nbtEntry.getValue())) continue;
                                        valid = false;
                                        break;
                                    }
                                    if (!valid) continue;
                                    bedrockBlock = block;
                                    break;
                                }
                                if (bedrockBlock == null) {
                                    throw new RuntimeException("Could not find a block match for " + entry.getKey());
                                }
                            }
                            if (customBlockItemOverride != null) {
                                bedrockBlock = customBlockItemOverride;
                            }
                            for (int j = 0; j < creativeItems.size(); ++j) {
                                ItemData itemData = (ItemData)creativeItems.get(j);
                                if (!itemData.getDefinition().equals(definition)) continue;
                                if (itemData.getDamage() != 0) break;
                                NbtMap states = ((GeyserBedrockBlock)itemData.getBlockDefinition()).getState().getCompound("states");
                                boolean valid = true;
                                blockTag = requiredBlockStates.entrySet().iterator();
                                while (blockTag.hasNext()) {
                                    Map.Entry entry3 = (Map.Entry)blockTag.next();
                                    if (Objects.equals(states.get(entry3.getKey()), entry3.getValue())) continue;
                                    valid = false;
                                    break;
                                }
                                if (!valid) continue;
                                if (customBlockItemOverride != null && customBlockData != null) {
                                    int customProtocolId = nextFreeBedrockId++;
                                    mappingItem = mappingItem.withBedrockData(customProtocolId);
                                    bedrockIdentifier = customBlockData.identifier();
                                    definition = new SimpleItemDefinition(bedrockIdentifier, customProtocolId, true);
                                    registry.put(customProtocolId, definition);
                                    customBlockItemDefinitions.put((Object)customBlockData, (Object)definition);
                                    customIdMappings.put(customProtocolId, bedrockIdentifier);
                                    creativeItems.set(j, itemData.toBuilder().definition(definition).blockDefinition((BlockDefinition)bedrockBlock).netId(itemData.getNetId()).count(1).build());
                                    break;
                                }
                                creativeItems.set(j, itemData.toBuilder().blockDefinition((BlockDefinition)bedrockBlock).build());
                                break;
                            }
                        }
                    }
                }
                ItemMapping.ItemMappingBuilder mappingBuilder = ItemMapping.builder().bedrockIdentifier(bedrockIdentifier.intern()).bedrockDefinition(definition).bedrockData(mappingItem.getBedrockData()).bedrockBlockDefinition((BlockDefinition)bedrockBlock).javaItem(javaItem);
                if (mappingItem.getToolType() != null) {
                    mappingBuilder = mappingItem.getToolTier() != null ? mappingBuilder.toolType(mappingItem.getToolType().intern()).toolTier(mappingItem.getToolTier().intern()) : mappingBuilder.toolType(mappingItem.getToolType().intern()).toolTier("");
                }
                if (javaOnlyItems.contains(javaItem)) {
                    mappingBuilder = mappingBuilder.translationString((bedrockBlock != null ? "block." : "item.") + entry.getKey().replace(":", "."));
                    GeyserImpl.getInstance().getLogger().debug("Adding " + entry.getKey() + " as an item that needs to be translated.");
                }
                Collection customItemsToLoad = customItems.get((Object)javaItem.javaIdentifier());
                if (customItemsAllowed && !customItemsToLoad.isEmpty()) {
                    customItemOptions = new ObjectArrayList<Pair<CustomItemOptions, ItemDefinition>>(customItemsToLoad.size());
                    for (CustomItemData customItem : customItemsToLoad) {
                        String customItemName;
                        int customProtocolId = nextFreeBedrockId++;
                        if (customItem instanceof NonVanillaCustomItemData) {
                            NonVanillaCustomItemData nonVanillaItem = (NonVanillaCustomItemData)customItem;
                            v1 = nonVanillaItem.identifier();
                        } else {
                            v1 = customItemName = "geyser_custom:" + customItem.name();
                        }
                        if (!registeredItemNames.add(customItemName)) {
                            if (!firstMappingsPass) continue;
                            GeyserImpl.getInstance().getLogger().error("Custom item name '" + customItemName + "' already exists and was registered again! Skipping...");
                            continue;
                        }
                        GeyserCustomMappingData customMapping = CustomItemRegistryPopulator.registerCustomItem(customItemName, javaItem, mappingItem, customItem, customProtocolId, palette.protocolVersion);
                        componentItemData.add(customMapping.componentItemData());
                        customItemOptions.add(Pair.of(customItem.customItemOptions(), customMapping.itemDefinition()));
                        registry.put(customMapping.integerId(), customMapping.itemDefinition());
                        customIdMappings.put(customMapping.integerId(), customMapping.stringId());
                    }
                    Collections.reverse(customItemOptions);
                } else {
                    customItemOptions = Collections.emptyList();
                }
                mappingBuilder.customItemOptions(customItemOptions);
                ItemMapping mapping = mappingBuilder.build();
                if (javaItem.javaIdentifier().contains("bucket") && !javaItem.javaIdentifier().contains("milk")) {
                    buckets.add(definition);
                } else if (javaItem.javaIdentifier().contains("_carpet") && !javaItem.javaIdentifier().contains("moss")) {
                    carpets.add(ItemData.builder().definition(definition).damage(mapping.getBedrockData()).count(1).blockDefinition(mapping.getBedrockBlockDefinition()).build());
                } else if (javaItem.javaIdentifier().startsWith("minecraft:music_disc_")) {
                    Registries.RECORDS.register(javaItem.javaId(), SoundEvent.valueOf("RECORD_" + mapping.getBedrockIdentifier().replace("minecraft:music_disc_", "").toUpperCase(Locale.ENGLISH)));
                }
                mappings.add(mapping);
                javaItemToMapping.put(javaItem, mapping);
            }
            ItemDefinition lodestoneCompass = (ItemDefinition)definitions.get("minecraft:lodestone_compass");
            if (lodestoneCompass == null) {
                throw new RuntimeException("Lodestone compass not found in item palette!");
            }
            ItemMapping lodestoneEntry = ItemMapping.builder().javaItem(Items.COMPASS).bedrockIdentifier("minecraft:lodestone_compass").bedrockDefinition(lodestoneCompass).bedrockData(0).bedrockBlockDefinition(null).customItemOptions(Collections.emptyList()).build();
            if (customItemsAllowed) {
                CustomBlockData[] definition = new SimpleItemDefinition("geysermc:furnace_minecart", nextFreeBedrockId, true);
                definitions.put("geysermc:furnace_minecart", definition);
                registry.put(definition.getRuntimeId(), (ItemDefinition)definition);
                mappings.set(Items.FURNACE_MINECART.javaId(), ItemMapping.builder().javaItem(Items.FURNACE_MINECART).bedrockIdentifier("geysermc:furnace_minecart").bedrockDefinition((ItemDefinition)definition).bedrockData(0).bedrockBlockDefinition(null).customItemOptions(Collections.emptyList()).build());
                creativeItems.add(ItemData.builder().netId(creativeNetId.incrementAndGet()).definition((ItemDefinition)definition).count(1).build());
                ItemRegistryPopulator.registerFurnaceMinecart(nextFreeBedrockId++, componentItemData, palette.protocolVersion);
                IntOpenHashSet registeredJavaIds = new IntOpenHashSet();
                for (NonVanillaCustomItemData customItem : nonVanillaCustomItems) {
                    if (!registeredJavaIds.add(customItem.javaId())) {
                        if (!firstMappingsPass) continue;
                        GeyserImpl.getInstance().getLogger().error("Custom item java id " + customItem.javaId() + " already exists and was registered again! Skipping...");
                        continue;
                    }
                    int customItemId = nextFreeBedrockId++;
                    NonVanillaItemRegistration registration = CustomItemRegistryPopulator.registerCustomItem(customItem, customItemId, palette.protocolVersion);
                    componentItemData.add(registration.componentItemData());
                    ItemMapping mapping = registration.mapping();
                    Item javaItem = registration.javaItem();
                    while (javaItem.javaId() >= mappings.size()) {
                        mappings.add(ItemMapping.AIR);
                    }
                    mappings.set(javaItem.javaId(), mapping);
                    registry.put(customItemId, mapping.getBedrockDefinition());
                    if (customItem.creativeGroup() == null && !customItem.creativeCategory().isPresent()) continue;
                    creativeItems.add(ItemData.builder().definition(registration.mapping().getBedrockDefinition()).netId(creativeNetId.incrementAndGet()).count(1).build());
                }
            }
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                for (CustomBlockData customBlock : (CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()) {
                    if (customBlockItemDefinitions.containsKey((Object)customBlock) || customBlock instanceof NonVanillaCustomBlockData) continue;
                    int customProtocolId = nextFreeBedrockId++;
                    String identifier = customBlock.identifier();
                    SimpleItemDefinition definition = new SimpleItemDefinition(identifier, customProtocolId, true);
                    registry.put(customProtocolId, (ItemDefinition)definition);
                    customBlockItemDefinitions.put((Object)customBlock, (Object)definition);
                    customIdMappings.put(customProtocolId, identifier);
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockMappings.getCustomBlockStateDefinitions().getOrDefault((Object)customBlock.defaultBlockState(), null);
                    if (bedrockBlock == null || !customBlock.includedInCreativeInventory()) continue;
                    creativeItems.add(ItemData.builder().definition(definition).blockDefinition(bedrockBlock).netId(creativeNetId.incrementAndGet()).count(1).build());
                }
            }
            ItemMappings itemMappings = ItemMappings.builder().items(mappings.toArray(new ItemMapping[0])).creativeItems(creativeItems.toArray(new ItemData[0])).itemDefinitions(registry).storedItems(new StoredItemMappings((Map<Item, ItemMapping>)javaItemToMapping)).javaOnlyItems(javaOnlyItems).buckets(buckets).carpets(carpets).componentItemData(componentItemData).lodestoneCompass(lodestoneEntry).customIdMappings(customIdMappings).customBlockItemDefinitions((Object2ObjectMap<CustomBlockData, ItemDefinition>)customBlockItemDefinitions).build();
            Registries.ITEMS.register(palette.protocolVersion(), itemMappings);
            firstMappingsPass = false;
        }
    }

    private static void registerFurnaceMinecart(int nextFreeBedrockId, List<ComponentItemData> componentItemData, int protocolVersion) {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putString("name", "geysermc:furnace_minecart").putInt("id", nextFreeBedrockId);
        NbtMapBuilder itemProperties = NbtMap.builder();
        NbtMapBuilder componentBuilder = NbtMap.builder();
        NbtMap iconMap = GameProtocol.is1_20_60orHigher(protocolVersion) ? NbtMap.builder().putCompound("textures", NbtMap.builder().putString("default", "minecart_furnace").build()).build() : NbtMap.builder().putString("texture", "minecart_furnace").build();
        itemProperties.putCompound("minecraft:icon", iconMap);
        componentBuilder.putCompound("minecraft:display_name", NbtMap.builder().putString("value", "item.minecartFurnace.name").build());
        List<NbtMap> useOnTag = Collections.singletonList(NbtMap.builder().putString("tags", "q.any_tag('rail')").build());
        componentBuilder.putCompound("minecraft:entity_placer", NbtMap.builder().putList("dispense_on", NbtType.COMPOUND, useOnTag).putString("entity", "minecraft:minecart").putList("use_on", NbtType.COMPOUND, useOnTag).build());
        itemProperties.putBoolean("allow_off_hand", true);
        itemProperties.putBoolean("hand_equipped", false);
        itemProperties.putInt("max_stack_size", 1);
        itemProperties.putString("creative_group", "itemGroup.name.minecart");
        itemProperties.putInt("creative_category", 4);
        componentBuilder.putCompound("item_properties", itemProperties.build());
        builder.putCompound("components", componentBuilder.build());
        componentItemData.add(new ComponentItemData("geysermc:furnace_minecart", builder.build()));
    }

    private static /* synthetic */ void lambda$populate$0(AtomicInteger creativeNetId, List creativeItems, Object2IntMap blacklistedIdentifiers, Object2ObjectMap bedrockBlockIdOverrides, ItemData.Builder itemBuilder) {
        String identifier;
        ItemData item = itemBuilder.netId(creativeNetId.incrementAndGet()).build();
        creativeItems.add(item);
        if (item.getBlockDefinition() != null && !blacklistedIdentifiers.containsKey(identifier = item.getDefinition().getIdentifier())) {
            if (bedrockBlockIdOverrides.containsKey((Object)identifier)) {
                bedrockBlockIdOverrides.remove((Object)identifier);
                blacklistedIdentifiers.put(identifier, item.getBlockDefinition().getRuntimeId());
            } else {
                bedrockBlockIdOverrides.put((Object)identifier, (Object)item.getBlockDefinition());
            }
        }
    }

    record PaletteVersion(String version, int protocolVersion, Map<Item, String> javaOnlyItems, Remapper remapper) {
        public PaletteVersion(String version, int protocolVersion) {
            this(version, protocolVersion, Collections.emptyMap(), (item, mapping) -> mapping);
        }
    }

    @FunctionalInterface
    static interface Remapper {
        public @NonNull GeyserMappingItem remap(Item var1, GeyserMappingItem var2);
    }
}

