/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.cloudburstmc.blockstateupdater.BlockStateUpdater;
import org.cloudburstmc.blockstateupdater.util.tagupdater.CompoundTagUpdaterContext;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.codec.v622.Bedrock_v622;
import org.cloudburstmc.protocol.bedrock.codec.v630.Bedrock_v630;
import org.cloudburstmc.protocol.bedrock.codec.v649.Bedrock_v649;
import org.cloudburstmc.protocol.bedrock.data.BlockPropertyData;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBlockState;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.physics.PistonBehavior;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.populator.Conversion630_622;
import org.geysermc.geyser.registry.populator.CustomBlockRegistryPopulator;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.relocate.jackson.databind.JsonNode;
import org.geysermc.relocate.jackson.databind.node.ArrayNode;

public final class BlockRegistryPopulator {
    private static JsonNode BLOCKS_JSON;
    private static int MIN_CUSTOM_RUNTIME_ID;
    private static int JAVA_BLOCKS_SIZE;
    private static final long FNV1_64_OFFSET_BASIS = -3750763034362895579L;
    private static final long FNV1_64_PRIME = 1099511628211L;

    public static void populate(Stage stage) {
        switch (stage) {
            case PRE_INIT: 
            case POST_INIT: {
                BlockRegistryPopulator.nullifyBlocksNode();
                break;
            }
            case INIT_JAVA: {
                BlockRegistryPopulator.registerJavaBlocks();
                break;
            }
            case INIT_BEDROCK: {
                BlockRegistryPopulator.registerBedrockBlocks();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stage: " + stage);
            }
        }
    }

    private static void nullifyBlocksNode() {
        BLOCKS_JSON = null;
    }

    private static void registerBedrockBlocks() {
        ImmutableMap blockMappers = ImmutableMap.builder().put(ObjectIntPair.of("1_20_40", Bedrock_v622.CODEC.getProtocolVersion()), Conversion630_622::remapBlock).put(ObjectIntPair.of("1_20_50", Bedrock_v630.CODEC.getProtocolVersion()), tag -> tag).put(ObjectIntPair.of("1_20_60", Bedrock_v649.CODEC.getProtocolVersion()), tag -> tag).build();
        Interner statesInterner = Interners.newStrongInterner();
        for (ObjectIntPair palette : blockMappers.keySet()) {
            ArrayList<NbtMap> blockStates;
            ArrayList<NbtMap> vanillaBlockStates;
            int protocolVersion = palette.valueInt();
            try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(String.format("bedrock/block_palette.%s.nbt", palette.key()));
                 NBTInputStream nbtInputStream = new NBTInputStream(new DataInputStream(new GZIPInputStream(stream)), true, true);){
                NbtMap blockPalette = (NbtMap)nbtInputStream.readTag();
                vanillaBlockStates = new ArrayList<NbtMap>(blockPalette.getList("blocks", NbtType.COMPOUND));
                for (int i = 0; i < vanillaBlockStates.size(); ++i) {
                    CustomBlockData[] builder = ((NbtMap)vanillaBlockStates.get(i)).toBuilder();
                    builder.remove("version");
                    builder.remove("name_hash");
                    builder.remove("network_id");
                    builder.remove("block_id");
                    builder.putCompound("states", (NbtMap)statesInterner.intern((Object)((NbtMap)builder.remove("states"))));
                    vanillaBlockStates.set(i, builder.build());
                }
                blockStates = new ArrayList<NbtMap>(vanillaBlockStates);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to get blocks from runtime block states", e);
            }
            ArrayList<BlockPropertyData> customBlockProperties = new ArrayList<BlockPropertyData>();
            ArrayList<NbtMap> customBlockStates = new ArrayList<NbtMap>();
            ArrayList<CustomBlockState> customExtBlockStates = new ArrayList<CustomBlockState>();
            int[] remappedVanillaIds = new int[]{};
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                CustomBlockRegistryPopulator.BLOCK_ID.set(10000);
                for (CustomBlockData customBlock : (CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()) {
                    customBlockProperties.add(CustomBlockRegistryPopulator.generateBlockPropertyData(customBlock, protocolVersion));
                    CustomBlockRegistryPopulator.generateCustomBlockStates(customBlock, customBlockStates, customExtBlockStates);
                }
                blockStates.addAll(customBlockStates);
                GeyserImpl.getInstance().getLogger().debug("Added " + customBlockStates.size() + " custom block states to v" + protocolVersion + " palette.");
                blockStates.sort((a, b) -> Long.compareUnsigned(BlockRegistryPopulator.fnv164(a.getString("name")), BlockRegistryPopulator.fnv164(b.getString("name"))));
            }
            Object2ObjectOpenHashMap blockStateOrderedMap = new Object2ObjectOpenHashMap(blockStates.size());
            GeyserBedrockBlock[] bedrockRuntimeMap = new GeyserBedrockBlock[blockStates.size()];
            for (int i = 0; i < blockStates.size(); ++i) {
                NbtMap tag2 = (NbtMap)blockStates.get(i);
                if (blockStateOrderedMap.containsKey((Object)tag2)) {
                    throw new AssertionError((Object)("Duplicate block states in Bedrock palette: " + tag2));
                }
                GeyserBedrockBlock block = new GeyserBedrockBlock(i, tag2);
                blockStateOrderedMap.put((Object)tag2, (Object)block);
                bedrockRuntimeMap[i] = block;
            }
            Object2ObjectMap customBlockStateDefinitions = Object2ObjectMaps.emptyMap();
            Int2ObjectOpenHashMap<GeyserBedrockBlock> extendedCollisionBoxes = new Int2ObjectOpenHashMap<GeyserBedrockBlock>();
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                int i;
                customBlockStateDefinitions = new Object2ObjectOpenHashMap(customExtBlockStates.size());
                for (i = 0; i < customExtBlockStates.size(); ++i) {
                    NbtMap tag3 = (NbtMap)customBlockStates.get(i);
                    CustomBlockState blockState = (CustomBlockState)customExtBlockStates.get(i);
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockStateOrderedMap.get((Object)tag3);
                    customBlockStateDefinitions.put((Object)blockState, (Object)bedrockBlock);
                    Set extendedCollisionjavaIds = BlockRegistries.EXTENDED_COLLISION_BOXES.getOrDefault(blockState.block(), null);
                    if (extendedCollisionjavaIds == null) continue;
                    Iterator iterator = extendedCollisionjavaIds.iterator();
                    while (iterator.hasNext()) {
                        int javaId = (Integer)iterator.next();
                        extendedCollisionBoxes.put(javaId, bedrockBlock);
                    }
                }
                remappedVanillaIds = new int[vanillaBlockStates.size()];
                for (i = 0; i < vanillaBlockStates.size(); ++i) {
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockStateOrderedMap.get(vanillaBlockStates.get(i));
                    remappedVanillaIds[i] = bedrockBlock != null ? bedrockBlock.getRuntimeId() : -1;
                }
            }
            int javaRuntimeId = -1;
            GeyserBedrockBlock airDefinition = null;
            GeyserBedrockBlock commandBlockDefinition = null;
            GeyserBedrockBlock mobSpawnerBlockDefinition = null;
            GeyserBedrockBlock waterDefinition = null;
            GeyserBedrockBlock movingBlockDefinition = null;
            Iterator<Map.Entry<String, JsonNode>> blocksIterator = BLOCKS_JSON.fields();
            Remapper stateMapper = (Remapper)blockMappers.get((Object)palette);
            Object[] javaToBedrockBlocks = new GeyserBedrockBlock[JAVA_BLOCKS_SIZE];
            Object[] javaToVanillaBedrockBlocks = new GeyserBedrockBlock[JAVA_BLOCKS_SIZE];
            Object2ObjectOpenHashMap flowerPotBlocks = new Object2ObjectOpenHashMap();
            Object2ObjectOpenHashMap itemFrames = new Object2ObjectOpenHashMap();
            ObjectOpenHashSet<BlockDefinition> jigsawDefinitions = new ObjectOpenHashSet<BlockDefinition>();
            BlockMappings.BlockMappingsBuilder builder = BlockMappings.builder();
            while (blocksIterator.hasNext()) {
                boolean waterlogged;
                GeyserBedrockBlock bedrockDefinition;
                ++javaRuntimeId;
                Map.Entry<String, JsonNode> entry = blocksIterator.next();
                String javaId = entry.getKey();
                NbtMap originalBedrockTag = BlockRegistryPopulator.buildBedrockState(entry.getValue());
                NbtMap bedrockTag = stateMapper.remap(originalBedrockTag);
                GeyserBedrockBlock vanillaBedrockDefinition = (GeyserBedrockBlock)blockStateOrderedMap.get((Object)bedrockTag);
                CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get(javaRuntimeId);
                if (blockStateOverride == null) {
                    bedrockDefinition = vanillaBedrockDefinition;
                    if (bedrockDefinition == null) {
                        throw new RuntimeException("Unable to find %s Bedrock runtime ID for %s! Original block tag:\n%s\nUpdated block tag:\n%s".formatted(javaId, palette.key(), originalBedrockTag, bedrockTag));
                    }
                } else {
                    bedrockDefinition = (GeyserBedrockBlock)customBlockStateDefinitions.get((Object)blockStateOverride);
                    if (bedrockDefinition == null) {
                        throw new RuntimeException("Unable to find " + javaId + " Bedrock runtime ID! Custom block override: \n" + blockStateOverride);
                    }
                }
                switch (javaId) {
                    case "minecraft:air": {
                        airDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:water[level=0]": {
                        waterDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:command_block[conditional=false,facing=north]": {
                        commandBlockDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:spawner": {
                        mobSpawnerBlockDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:moving_piston[facing=north,type=normal]": {
                        movingBlockDefinition = bedrockDefinition;
                    }
                }
                if (javaId.contains("jigsaw")) {
                    jigsawDefinitions.add(bedrockDefinition);
                }
                boolean bl = waterlogged = entry.getKey().contains("waterlogged=true") || javaId.contains("minecraft:bubble_column") || javaId.contains("minecraft:kelp") || javaId.contains("seagrass");
                if (waterlogged) {
                    int finalJavaRuntimeId = javaRuntimeId;
                    BlockRegistries.WATERLOGGED.register(set -> set.set(finalJavaRuntimeId));
                }
                String cleanJavaIdentifier = BlockUtils.getCleanIdentifier(entry.getKey());
                if (entry.getValue().get("pottable") != null) {
                    flowerPotBlocks.put(cleanJavaIdentifier.intern(), (NbtMap)blockStates.get(bedrockDefinition.getRuntimeId()));
                }
                javaToVanillaBedrockBlocks[javaRuntimeId] = vanillaBedrockDefinition;
                javaToBedrockBlocks[javaRuntimeId] = bedrockDefinition;
            }
            if (commandBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find command block in palette");
            }
            builder.commandBlock(commandBlockDefinition);
            if (mobSpawnerBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find mob spawner block in palette");
            }
            builder.mobSpawnerBlock(mobSpawnerBlockDefinition);
            if (waterDefinition == null) {
                throw new AssertionError((Object)"Unable to find water in palette");
            }
            builder.bedrockWater(waterDefinition);
            if (airDefinition == null) {
                throw new AssertionError((Object)"Unable to find air in palette");
            }
            builder.bedrockAir(airDefinition);
            if (movingBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find moving block in palette");
            }
            builder.bedrockMovingBlock(movingBlockDefinition);
            Map nonVanillaStateOverrides = (Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get();
            if (!nonVanillaStateOverrides.isEmpty()) {
                Arrays.fill(javaToVanillaBedrockBlocks, MIN_CUSTOM_RUNTIME_ID, javaToVanillaBedrockBlocks.length, airDefinition);
                Arrays.fill(javaToBedrockBlocks, MIN_CUSTOM_RUNTIME_ID, javaToBedrockBlocks.length, airDefinition);
                for (Map.Entry entry : nonVanillaStateOverrides.entrySet()) {
                    GeyserBedrockBlock bedrockDefinition = (GeyserBedrockBlock)customBlockStateDefinitions.get(entry.getValue());
                    if (bedrockDefinition == null) {
                        GeyserImpl.getInstance().getLogger().warning("Unable to find custom block for " + entry.getValue());
                        continue;
                    }
                    JavaBlockState javaState = (JavaBlockState)entry.getKey();
                    int stateRuntimeId = javaState.javaId();
                    boolean waterlogged = javaState.waterlogged();
                    if (waterlogged) {
                        BlockRegistries.WATERLOGGED.register(set -> set.set(stateRuntimeId));
                    }
                    javaToVanillaBedrockBlocks[stateRuntimeId] = bedrockDefinition;
                    javaToBedrockBlocks[stateRuntimeId] = bedrockDefinition;
                }
            }
            Object2ObjectMaps.fastForEach((Object2ObjectMap)blockStateOrderedMap, arg_0 -> BlockRegistryPopulator.lambda$registerBedrockBlocks$5((Map)itemFrames, arg_0));
            BlockRegistries.BLOCKS.register(palette.valueInt(), builder.bedrockRuntimeMap(bedrockRuntimeMap).javaToBedrockBlocks((GeyserBedrockBlock[])javaToBedrockBlocks).javaToVanillaBedrockBlocks((GeyserBedrockBlock[])javaToVanillaBedrockBlocks).stateDefinitionMap((Map<NbtMap, GeyserBedrockBlock>)blockStateOrderedMap).itemFrames((Map<NbtMap, BlockDefinition>)itemFrames).flowerPotBlocks((Map<String, NbtMap>)flowerPotBlocks).jigsawStates(jigsawDefinitions).remappedVanillaIds(remappedVanillaIds).blockProperties(customBlockProperties).customBlockStateDefinitions((Object2ObjectMap<CustomBlockState, GeyserBedrockBlock>)customBlockStateDefinitions).extendedCollisionBoxes(extendedCollisionBoxes).build());
        }
    }

    private static void registerJavaBlocks() {
        JsonNode blockInteractionsJson;
        String bedrockIdentifier;
        String cleanJavaIdentifier;
        JsonNode blocksJson;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/blocks.json");){
            blocksJson = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block mappings", e);
        }
        JAVA_BLOCKS_SIZE = blocksJson.size();
        if (!((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).isEmpty()) {
            MIN_CUSTOM_RUNTIME_ID = ((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).keySet().stream().min(Comparator.comparing(JavaBlockState::javaId)).orElseThrow().javaId();
            int maxCustomRuntimeID = ((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).keySet().stream().max(Comparator.comparing(JavaBlockState::javaId)).orElseThrow().javaId();
            if (MIN_CUSTOM_RUNTIME_ID < blocksJson.size()) {
                throw new RuntimeException("Non vanilla custom block state overrides runtime ID must start after the last vanilla block state (" + JAVA_BLOCKS_SIZE + ")");
            }
            JAVA_BLOCKS_SIZE = maxCustomRuntimeID + 1;
        }
        BlockRegistries.JAVA_BLOCKS.set((BlockMapping)new BlockMapping[JAVA_BLOCKS_SIZE]);
        ArrayDeque<String> cleanIdentifiers = new ArrayDeque<String>();
        int javaRuntimeId = -1;
        int cobwebBlockId = -1;
        int furnaceRuntimeId = -1;
        int furnaceLitRuntimeId = -1;
        int honeyBlockRuntimeId = -1;
        int slimeBlockRuntimeId = -1;
        int spawnerRuntimeId = -1;
        int uniqueJavaId = -1;
        int waterRuntimeId = -1;
        Iterator<Map.Entry<String, JsonNode>> blocksIterator = blocksJson.fields();
        while (blocksIterator.hasNext()) {
            JsonNode pickItemNode;
            JsonNode canBreakWithHandNode;
            ++javaRuntimeId;
            Map.Entry<String, JsonNode> entry = blocksIterator.next();
            String javaId = entry.getKey();
            BlockMapping.BlockMappingBuilder builder = BlockMapping.builder();
            JsonNode hardnessNode = entry.getValue().get("block_hardness");
            if (hardnessNode != null) {
                builder.hardness(hardnessNode.floatValue());
            }
            if ((canBreakWithHandNode = entry.getValue().get("can_break_with_hand")) != null) {
                builder.canBreakWithHand(canBreakWithHandNode.booleanValue());
            } else {
                builder.canBreakWithHand(false);
            }
            JsonNode collisionIndexNode = entry.getValue().get("collision_index");
            if (hardnessNode != null) {
                builder.collisionIndex(collisionIndexNode.intValue());
            }
            if ((pickItemNode = entry.getValue().get("pick_item")) != null) {
                builder.pickItem(pickItemNode.textValue().intern());
            }
            if (javaId.equals("minecraft:obsidian") || javaId.equals("minecraft:crying_obsidian") || javaId.startsWith("minecraft:respawn_anchor") || javaId.startsWith("minecraft:reinforced_deepslate")) {
                builder.pistonBehavior(PistonBehavior.BLOCK);
            } else {
                JsonNode pistonBehaviorNode = entry.getValue().get("piston_behavior");
                if (pistonBehaviorNode != null) {
                    builder.pistonBehavior(PistonBehavior.getByName(pistonBehaviorNode.textValue()));
                } else {
                    builder.pistonBehavior(PistonBehavior.NORMAL);
                }
            }
            JsonNode hasBlockEntityNode = entry.getValue().get("has_block_entity");
            if (hasBlockEntityNode != null) {
                builder.isBlockEntity(hasBlockEntityNode.booleanValue());
            } else {
                builder.isBlockEntity(false);
            }
            BlockStateValues.storeBlockStateValues(entry.getKey(), javaRuntimeId, entry.getValue());
            cleanJavaIdentifier = BlockUtils.getCleanIdentifier(entry.getKey());
            bedrockIdentifier = entry.getValue().get("bedrock_identifier").asText();
            if (!cleanJavaIdentifier.equals(cleanIdentifiers.peekLast())) {
                ++uniqueJavaId;
                cleanIdentifiers.add(cleanJavaIdentifier.intern());
            }
            builder.javaIdentifier(javaId);
            builder.javaBlockId(uniqueJavaId);
            BlockRegistries.JAVA_IDENTIFIER_TO_ID.register(javaId, javaRuntimeId);
            BlockRegistries.JAVA_BLOCKS.register(javaRuntimeId, builder.build());
            BlockRegistries.JAVA_TO_BEDROCK_IDENTIFIERS.register(cleanJavaIdentifier.intern(), bedrockIdentifier.intern());
            if (javaId.contains("cobweb")) {
                cobwebBlockId = uniqueJavaId;
                continue;
            }
            if (javaId.startsWith("minecraft:furnace[facing=north")) {
                if (javaId.contains("lit=true")) {
                    furnaceLitRuntimeId = javaRuntimeId;
                    continue;
                }
                furnaceRuntimeId = javaRuntimeId;
                continue;
            }
            if (javaId.startsWith("minecraft:spawner")) {
                spawnerRuntimeId = javaRuntimeId;
                continue;
            }
            if ("minecraft:water[level=0]".equals(javaId)) {
                waterRuntimeId = javaRuntimeId;
                continue;
            }
            if (javaId.equals("minecraft:honey_block")) {
                honeyBlockRuntimeId = javaRuntimeId;
                continue;
            }
            if (!javaId.equals("minecraft:slime_block")) continue;
            slimeBlockRuntimeId = javaRuntimeId;
        }
        if (cobwebBlockId == -1) {
            throw new AssertionError((Object)"Unable to find cobwebs in palette");
        }
        BlockStateValues.JAVA_COBWEB_ID = cobwebBlockId;
        if (furnaceRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find furnace in palette");
        }
        BlockStateValues.JAVA_FURNACE_ID = furnaceRuntimeId;
        if (furnaceLitRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find lit furnace in palette");
        }
        BlockStateValues.JAVA_FURNACE_LIT_ID = furnaceLitRuntimeId;
        if (honeyBlockRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find honey block in palette");
        }
        BlockStateValues.JAVA_HONEY_BLOCK_ID = honeyBlockRuntimeId;
        if (slimeBlockRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find slime block in palette");
        }
        BlockStateValues.JAVA_SLIME_BLOCK_ID = slimeBlockRuntimeId;
        if (spawnerRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find spawner in palette");
        }
        BlockStateValues.JAVA_SPAWNER_ID = spawnerRuntimeId;
        if (waterRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find Java water in palette");
        }
        BlockStateValues.JAVA_WATER_ID = waterRuntimeId;
        if (!((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).isEmpty()) {
            HashSet<Integer> usedNonVanillaRuntimeIDs = new HashSet<Integer>();
            for (JavaBlockState javaBlockState : ((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).keySet()) {
                if (!usedNonVanillaRuntimeIDs.add(javaBlockState.javaId())) {
                    throw new RuntimeException("Duplicate runtime ID " + javaBlockState.javaId() + " for non vanilla Java block state " + javaBlockState.identifier());
                }
                CustomBlockState customBlockState = (CustomBlockState)((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).get(javaBlockState);
                String javaId = javaBlockState.identifier();
                int stateRuntimeId = javaBlockState.javaId();
                String pistonBehavior = javaBlockState.pistonBehavior();
                BlockMapping blockMapping = BlockMapping.builder().canBreakWithHand(javaBlockState.canBreakWithHand()).pickItem(javaBlockState.pickItem()).isNonVanilla(true).javaIdentifier(javaId).javaBlockId(javaBlockState.stateGroupId()).hardness(javaBlockState.blockHardness()).pistonBehavior(pistonBehavior == null ? PistonBehavior.NORMAL : PistonBehavior.getByName(pistonBehavior)).isBlockEntity(javaBlockState.hasBlockEntity()).build();
                cleanJavaIdentifier = BlockUtils.getCleanIdentifier(javaBlockState.identifier());
                bedrockIdentifier = customBlockState.block().identifier();
                if (!cleanJavaIdentifier.equals(cleanIdentifiers.peekLast())) {
                    ++uniqueJavaId;
                    cleanIdentifiers.add(cleanJavaIdentifier.intern());
                }
                BlockRegistries.JAVA_IDENTIFIER_TO_ID.register(javaId, stateRuntimeId);
                BlockRegistries.JAVA_BLOCKS.register(stateRuntimeId, blockMapping);
                BlockRegistries.JAVA_TO_BEDROCK_IDENTIFIERS.register(cleanJavaIdentifier.intern(), bedrockIdentifier.intern());
            }
        }
        BlockRegistries.CLEAN_JAVA_IDENTIFIERS.set((String)cleanIdentifiers.toArray(new String[0]));
        BLOCKS_JSON = blocksJson;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/interactions.json");){
            blockInteractionsJson = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block interaction mappings", e);
        }
        BlockRegistries.INTERACTIVE.set(BlockRegistryPopulator.toBlockStateSet((ArrayNode)blockInteractionsJson.get("always_consumes")));
        BlockRegistries.INTERACTIVE_MAY_BUILD.set(BlockRegistryPopulator.toBlockStateSet((ArrayNode)blockInteractionsJson.get("requires_may_build")));
    }

    private static BitSet toBlockStateSet(ArrayNode node) {
        BitSet blockStateSet = new BitSet(node.size());
        for (JsonNode javaIdentifier : node) {
            blockStateSet.set(((Object2IntMap)BlockRegistries.JAVA_IDENTIFIER_TO_ID.get()).getInt(javaIdentifier.textValue()));
        }
        return blockStateSet;
    }

    private static NbtMap buildBedrockState(JsonNode node) {
        NbtMapBuilder tagBuilder = NbtMap.builder();
        String bedrockIdentifier = node.get("bedrock_identifier").textValue();
        tagBuilder.putString("name", bedrockIdentifier);
        NbtMapBuilder statesBuilder = NbtMap.builder();
        JsonNode states = node.get("bedrock_states");
        if (states != null) {
            Iterator<Map.Entry<String, JsonNode>> statesIterator = states.fields();
            while (statesIterator.hasNext()) {
                Map.Entry<String, JsonNode> stateEntry = statesIterator.next();
                JsonNode stateValue = stateEntry.getValue();
                switch (stateValue.getNodeType()) {
                    case BOOLEAN: {
                        statesBuilder.putBoolean(stateEntry.getKey(), stateValue.booleanValue());
                        break;
                    }
                    case STRING: {
                        statesBuilder.putString(stateEntry.getKey(), stateValue.textValue());
                        break;
                    }
                    case NUMBER: {
                        statesBuilder.putInt(stateEntry.getKey(), stateValue.intValue());
                    }
                }
            }
        }
        tagBuilder.put("states", (Object)statesBuilder.build());
        return tagBuilder.build();
    }

    private static long fnv164(String str) {
        long hash = -3750763034362895579L;
        for (byte b : str.getBytes(StandardCharsets.UTF_8)) {
            hash *= 1099511628211L;
            hash ^= (long)b;
        }
        return hash;
    }

    private static /* synthetic */ void lambda$registerBedrockBlocks$5(Map itemFrames, Object2ObjectMap.Entry entry) {
        String name = ((NbtMap)entry.getKey()).getString("name");
        if (name.equals("minecraft:frame") || name.equals("minecraft:glow_frame")) {
            itemFrames.put((NbtMap)entry.getKey(), (BlockDefinition)entry.getValue());
        }
    }

    static {
        MIN_CUSTOM_RUNTIME_ID = -1;
        JAVA_BLOCKS_SIZE = -1;
    }

    public static enum Stage {
        PRE_INIT,
        INIT_JAVA,
        INIT_BEDROCK,
        POST_INIT;

    }

    @FunctionalInterface
    static interface Remapper {
        public NbtMap remap(NbtMap var1);

        public static Remapper of(BlockStateUpdater ... updaters) {
            CompoundTagUpdaterContext context = new CompoundTagUpdaterContext();
            for (BlockStateUpdater updater : updaters) {
                updater.registerUpdaters(context);
            }
            return tag -> {
                NbtMapBuilder updated = context.update(tag, 0).toBuilder();
                updated.remove("version");
                return updated.build();
            };
        }
    }
}

