/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.fabric;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.text.ChatColor;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.geysermc.relocate.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class GeyserFabricLogger
implements GeyserLogger {
    private final Logger logger = LogManager.getLogger((String)"geyser-fabric");
    private boolean debug;

    public GeyserFabricLogger(boolean isDebug) {
        this.debug = isDebug;
    }

    @Override
    public void severe(String message) {
        this.logger.fatal(message);
    }

    @Override
    public void severe(String message, Throwable error) {
        this.logger.fatal(message, error);
    }

    @Override
    public void error(String message) {
        this.logger.error(message);
    }

    @Override
    public void error(String message, Throwable error) {
        this.logger.error(message, error);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(message);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void sendMessage(Component message) {
        String flattened = LegacyComponentSerializer.legacySection().serialize(message);
        String text = ChatColor.toANSI(flattened) + "\u001b[0m";
        this.info(text);
    }

    @Override
    public void debug(String message) {
        if (this.debug) {
            this.logger.info(message);
        }
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }
}

