/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.UnixChannelOption;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public final class Bootstraps {
    private static final Optional<int[]> KERNEL_VERSION;
    private static final int[] REUSEPORT_VERSION;
    private static final boolean REUSEPORT_AVAILABLE;

    public static Optional<int[]> getKernelVersion() {
        return KERNEL_VERSION;
    }

    public static boolean isReusePortAvailable() {
        return REUSEPORT_AVAILABLE;
    }

    public static void setupBootstrap(AbstractBootstrap bootstrap) {
        if (REUSEPORT_AVAILABLE) {
            bootstrap.option(UnixChannelOption.SO_REUSEPORT, (Object)true);
        }
    }

    private static int[] fromString(String ver) {
        String[] parts = ver.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("At least 2 version numbers required");
        }
        return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), parts.length == 2 ? 0 : Integer.parseInt(parts[2])};
    }

    private static boolean checkVersion(int[] ver, int i) {
        if (ver[i] > REUSEPORT_VERSION[i]) {
            return true;
        }
        if (ver[i] == REUSEPORT_VERSION[i]) {
            if (ver.length == i + 1) {
                return true;
            }
            return Bootstraps.checkVersion(ver, i + 1);
        }
        return false;
    }

    public static CompletableFuture<Void> allOf(ChannelFuture ... futures) {
        if (futures == null || futures.length == 0) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] completableFutures = new CompletableFuture[futures.length];
        for (int i = 0; i < futures.length; ++i) {
            ChannelFuture channelFuture = futures[i];
            CompletableFuture completableFuture = new CompletableFuture();
            channelFuture.addListener(future -> {
                if (future.cause() != null) {
                    completableFuture.completeExceptionally(future.cause());
                }
                completableFuture.complete(channelFuture.channel());
            });
            completableFutures[i] = completableFuture;
        }
        return CompletableFuture.allOf(completableFutures);
    }

    private Bootstraps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        String kernelVersion;
        REUSEPORT_VERSION = new int[]{3, 9, 0};
        try {
            kernelVersion = Native.KERNEL_VERSION;
        }
        catch (Throwable e) {
            kernelVersion = null;
        }
        if (kernelVersion != null && kernelVersion.contains("-")) {
            int index = kernelVersion.indexOf(45);
            if (index > -1) {
                kernelVersion = kernelVersion.substring(0, index);
            }
            int[] kernelVer = Bootstraps.fromString(kernelVersion);
            KERNEL_VERSION = Optional.of(kernelVer);
            REUSEPORT_AVAILABLE = Bootstraps.checkVersion(kernelVer, 0);
        } else {
            KERNEL_VERSION = Optional.empty();
            REUSEPORT_AVAILABLE = false;
        }
    }
}

