/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.util.MathUtils;

public class ShulkerBoxItem
extends BlockItem {
    public ShulkerBoxItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        CompoundTag blockEntityTag = (CompoundTag)tag.get("BlockEntityTag");
        if (blockEntityTag == null) {
            return;
        }
        if (blockEntityTag.get("Items") == null) {
            return;
        }
        ListTag itemsList = new ListTag("Items");
        for (Tag item : (ListTag)blockEntityTag.get("Items")) {
            CompoundTag itemData = (CompoundTag)item;
            CompoundTag boxItemTag = new CompoundTag("");
            boxItemTag.put(new ByteTag("Slot", (byte)(MathUtils.getNbtByte(((Tag)itemData.get("Slot")).getValue()) & 0xFF)));
            boxItemTag.put(new ByteTag("WasPickedUp", 0));
            ItemMapping boxMapping = session.getItemMappings().getMapping(Identifier.formalize(((StringTag)itemData.get("id")).getValue()));
            if (boxMapping == null) continue;
            boxItemTag.put(new StringTag("Name", boxMapping.getBedrockIdentifier()));
            boxItemTag.put(new ShortTag("Damage", (short)boxMapping.getBedrockData()));
            boxItemTag.put(new ByteTag("Count", MathUtils.getNbtByte(((Tag)itemData.get("Count")).getValue())));
            CompoundTag displayTag = (CompoundTag)itemData.get("tag");
            if (displayTag == null && boxMapping.hasTranslation()) {
                displayTag = new CompoundTag("tag");
            }
            if (displayTag != null) {
                boxItemTag.put(ItemTranslator.translateDisplayProperties(session, displayTag, boxMapping, '7'));
            }
            itemsList.add(boxItemTag);
        }
        tag.put(itemsList);
        tag.remove("BlockEntityTag");
    }

    @Override
    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(tag, mapping);
        tag.remove("Items");
    }
}

