/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.translator.inventory.item.CustomItemTranslator;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;

public class PotionItem
extends Item {
    public PotionItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        if (itemStack.getNbt() == null) {
            return super.translateToBedrock(itemStack, mapping, mappings);
        }
        Object potionTag = itemStack.getNbt().get("Potion");
        if (potionTag instanceof StringTag) {
            ItemDefinition customItemDefinition = CustomItemTranslator.getCustomItem(itemStack.getNbt(), mapping);
            if (customItemDefinition == null) {
                Potion potion = Potion.getByJavaIdentifier(((StringTag)potionTag).getValue());
                if (potion != null) {
                    return ItemData.builder().definition(mapping.getBedrockDefinition()).damage(potion.getBedrockId()).count(itemStack.getAmount()).tag(ItemTranslator.translateNbtToBedrock(itemStack.getNbt()));
                }
                GeyserImpl.getInstance().getLogger().debug("Unknown Java potion: " + ((Tag)potionTag).getValue());
            } else {
                return ItemData.builder().definition(customItemDefinition).count(itemStack.getAmount()).tag(ItemTranslator.translateNbtToBedrock(itemStack.getNbt()));
            }
        }
        return super.translateToBedrock(itemStack, mapping, mappings);
    }

    @Override
    public @NonNull ItemStack translateToJava(@NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        Potion potion = Potion.getByBedrockId(itemData.getDamage());
        ItemStack itemStack = super.translateToJava(itemData, mapping, mappings);
        if (potion != null) {
            StringTag potionTag = new StringTag("Potion", potion.getJavaIdentifier());
            itemStack.getNbt().put(potionTag);
        }
        return itemStack;
    }
}

