/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;

public class PlayerHeadItem
extends Item {
    public PlayerHeadItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        CompoundTag displayTag;
        super.translateNbtToBedrock(session, tag);
        Object t = tag.get("display");
        if (t instanceof CompoundTag) {
            CompoundTag existingDisplayTag;
            displayTag = existingDisplayTag = (CompoundTag)t;
        } else {
            displayTag = new CompoundTag("display");
            tag.put(displayTag);
        }
        t = displayTag.get("Name");
        if (t instanceof StringTag) {
            StringTag nameTag = (StringTag)t;
            displayTag.put(new StringTag("Name", "\u00a7e\u00a7o" + MessageTranslator.convertMessageLenient(nameTag.getValue(), session.locale())));
        } else if (tag.contains("SkullOwner")) {
            Object t2;
            StringTag name;
            Object skullOwner = tag.get("SkullOwner");
            if (skullOwner instanceof StringTag) {
                StringTag skullName;
                name = skullName = (StringTag)skullOwner;
            } else if (skullOwner instanceof CompoundTag && (t2 = ((CompoundTag)skullOwner).get("Name")) instanceof StringTag) {
                StringTag skullName;
                name = skullName = (StringTag)t2;
            } else {
                displayTag.put(new StringTag("Name", "\u00a7r\u00a7e" + MinecraftLocale.getLocaleString("block.minecraft.player_head", session.locale())));
                return;
            }
            String displayName = "\u00a7r\u00a7e" + MinecraftLocale.getLocaleString("block.minecraft.player_head.named", session.locale()).replace("%s", name.getValue());
            displayTag.put(new StringTag("Name", displayName));
        }
    }
}

