/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.erosion;

import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValueType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import io.netty.channel.Channel;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.erosion.packet.ErosionPacketHandler;
import org.geysermc.erosion.packet.ErosionPacketSender;
import org.geysermc.erosion.packet.backendbound.BackendboundInitializePacket;
import org.geysermc.erosion.packet.backendbound.BackendboundPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBatchBlockIdPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBlockEntityPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBlockIdPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBlockLookupFailPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBlockPlacePacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundHandshakePacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPickBlockPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPistonEventPacket;
import org.geysermc.geyser.erosion.AbstractGeyserboundPacketHandler;
import org.geysermc.geyser.erosion.GeyserboundHandshakePacketHandler;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.translator.level.block.entity.PistonBlockEntity;
import org.geysermc.geyser.util.BlockEntityUtils;

public final class GeyserboundPacketHandlerImpl
extends AbstractGeyserboundPacketHandler {
    private final ErosionPacketSender<BackendboundPacket> packetSender;
    private CompletableFuture<Integer> pendingLookup = null;
    private final Int2ObjectMap<CompletableFuture<Integer>> asyncPendingLookups = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap(4));
    private CompletableFuture<int[]> pendingBatchLookup = null;
    private CompletableFuture<CompoundTag> pickBlockLookup = null;
    private final AtomicInteger nextTransactionId = new AtomicInteger(1);

    public GeyserboundPacketHandlerImpl(GeyserSession session, ErosionPacketSender<BackendboundPacket> packetSender) {
        super(session);
        this.packetSender = packetSender;
    }

    @Override
    public void handleBatchBlockId(GeyserboundBatchBlockIdPacket packet) {
        if (this.pendingBatchLookup != null) {
            this.pendingBatchLookup.complete(packet.getBlocks());
        } else {
            this.session.getGeyser().getLogger().warning("Batch block ID packet received with no future to complete.");
        }
    }

    @Override
    public void handleBlockEntity(GeyserboundBlockEntityPacket packet) {
        NbtMap nbt = packet.getNbt();
        BlockEntityUtils.updateBlockEntity(this.session, nbt, Vector3i.from(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z")));
    }

    @Override
    public void handleBlockId(GeyserboundBlockIdPacket packet) {
        if (packet.getTransactionId() == 0 && this.pendingLookup != null) {
            this.pendingLookup.complete(packet.getBlockId());
            return;
        }
        CompletableFuture future = (CompletableFuture)this.asyncPendingLookups.remove(packet.getTransactionId());
        if (future != null) {
            future.complete(packet.getBlockId());
            return;
        }
        this.session.getGeyser().getLogger().warning("Block ID packet received with no future to complete.");
    }

    @Override
    public void handleBlockLookupFail(GeyserboundBlockLookupFailPacket packet) {
        CompletableFuture future;
        if (packet.getTransactionId() == 0 && this.pendingBatchLookup != null) {
            this.pendingBatchLookup.complete(null);
            return;
        }
        int transactionId = packet.getTransactionId() - 1;
        if (transactionId == 0 && this.pendingLookup != null) {
            this.pendingLookup.complete(0);
        }
        if ((future = (CompletableFuture)this.asyncPendingLookups.remove(transactionId)) != null) {
            future.complete(0);
        }
    }

    @Override
    public void handleBlockPlace(GeyserboundBlockPlacePacket packet) {
        LevelSoundEventPacket placeBlockSoundPacket = new LevelSoundEventPacket();
        placeBlockSoundPacket.setSound(SoundEvent.PLACE);
        placeBlockSoundPacket.setPosition(packet.getPos().toFloat());
        placeBlockSoundPacket.setBabySound(false);
        placeBlockSoundPacket.setExtraData(this.session.getBlockMappings().getBedrockBlockId(packet.getBlockId()));
        placeBlockSoundPacket.setIdentifier(":");
        this.session.sendUpstreamPacket(placeBlockSoundPacket);
        this.session.setLastBlockPlacePosition(null);
        this.session.setLastBlockPlacedId(null);
    }

    @Override
    public void handlePickBlock(GeyserboundPickBlockPacket packet) {
        if (this.pickBlockLookup != null) {
            this.pickBlockLookup.complete(packet.getTag());
        }
    }

    @Override
    public void handlePistonEvent(GeyserboundPistonEventPacket packet) {
        Direction orientation = BlockStateValues.getPistonOrientation(packet.getBlockId());
        Vector3i position = packet.getPos();
        boolean isExtend = packet.isExtend();
        Stream<Object2IntMap.Entry> stream = packet.getAttachedBlocks().object2IntEntrySet().stream().filter(entry -> BlockStateValues.canPistonMoveBlock(entry.getIntValue(), isExtend));
        Object2IntArrayMap attachedBlocks = new Object2IntArrayMap();
        stream.forEach(entry -> attachedBlocks.put((Vector3i)entry.getKey(), entry.getIntValue()));
        this.session.executeInEventLoop(() -> {
            PistonCache pistonCache = this.session.getPistonCache();
            PistonBlockEntity blockEntity = pistonCache.getPistons().computeIfAbsent(position, pos -> new PistonBlockEntity(this.session, position, orientation, packet.isSticky(), !isExtend));
            blockEntity.setAction(isExtend ? PistonValueType.PUSHING : PistonValueType.PULLING, attachedBlocks);
        });
    }

    @Override
    public void handleHandshake(GeyserboundHandshakePacket packet) {
        this.close();
        GeyserboundHandshakePacketHandler handler = new GeyserboundHandshakePacketHandler(this.session);
        this.session.setErosionHandler(handler);
        handler.handleHandshake(packet);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public GeyserboundPacketHandlerImpl getAsActive() {
        return this;
    }

    @Override
    public void onConnect() {
        this.sendPacket(new BackendboundInitializePacket(this.session.getPlayerEntity().getUuid(), GameProtocol.getJavaProtocolVersion()));
    }

    public void sendPacket(BackendboundPacket packet) {
        this.packetSender.sendPacket(packet);
    }

    @Override
    public void close() {
        this.packetSender.close();
    }

    public int getNextTransactionId() {
        return this.nextTransactionId.getAndIncrement();
    }

    @Override
    public ErosionPacketHandler setChannel(Channel channel) {
        this.packetSender.setChannel(channel);
        return this;
    }

    public void setPendingLookup(CompletableFuture<Integer> pendingLookup) {
        this.pendingLookup = pendingLookup;
    }

    public Int2ObjectMap<CompletableFuture<Integer>> getAsyncPendingLookups() {
        return this.asyncPendingLookups;
    }

    public void setPendingBatchLookup(CompletableFuture<int[]> pendingBatchLookup) {
        this.pendingBatchLookup = pendingBatchLookup;
    }

    public void setPickBlockLookup(CompletableFuture<CompoundTag> pickBlockLookup) {
        this.pickBlockLookup = pickBlockLookup;
    }
}

