/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.ThrowableItemEntity;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;

public class ThrownPotionEntity
extends ThrowableItemEntity {
    private static final EnumSet<Potion> NON_ENCHANTED_POTIONS = EnumSet.of(Potion.WATER, Potion.MUNDANE, Potion.THICK, Potion.AWKWARD);

    public ThrownPotionEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void setItem(EntityMetadata<ItemStack, ?> entityMetadata) {
        ItemStack itemStack = entityMetadata.getValue();
        if (itemStack == null) {
            this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, 0);
            this.setFlag(EntityFlag.ENCHANTED, false);
            this.setFlag(EntityFlag.LINGERING, false);
        } else if (itemStack.getNbt() != null) {
            Object potionTag = itemStack.getNbt().get("Potion");
            if (potionTag instanceof StringTag) {
                Potion potion = Potion.getByJavaIdentifier(((StringTag)potionTag).getValue());
                if (potion != null) {
                    this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, Integer.valueOf(potion.getBedrockId()));
                    this.setFlag(EntityFlag.ENCHANTED, !NON_ENCHANTED_POTIONS.contains((Object)potion));
                } else {
                    this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, 0);
                    GeyserImpl.getInstance().getLogger().debug("Unknown java potion: " + ((Tag)potionTag).getValue());
                }
            }
            boolean isLingering = ((List)Registries.JAVA_ITEMS.get()).get(itemStack.getId()) == Items.LINGERING_POTION;
            this.setFlag(EntityFlag.LINGERING, isLingering);
        }
    }
}

