/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.ThrowableEntity;
import org.geysermc.geyser.session.GeyserSession;

public class ThrowableItemEntity
extends ThrowableEntity {
    private int age;
    private boolean invisible;

    public ThrowableItemEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.setFlag(EntityFlag.INVISIBLE, true);
        this.invisible = false;
    }

    private void checkVisibility() {
        if (this.invisible != this.getFlag(EntityFlag.INVISIBLE)) {
            if (!this.invisible) {
                Vector3f playerPos = this.session.getPlayerEntity().getPosition();
                if (this.age >= 4 || this.position.distanceSquared(playerPos) > 16.0f) {
                    this.setFlag(EntityFlag.INVISIBLE, false);
                    this.updateBedrockMetadata();
                }
            } else {
                this.setFlag(EntityFlag.INVISIBLE, true);
                this.updateBedrockMetadata();
            }
        }
        ++this.age;
    }

    @Override
    public void tick() {
        this.checkVisibility();
        super.tick();
    }

    @Override
    protected void setInvisible(boolean value) {
        this.invisible = value;
    }

    public void setItem(EntityMetadata<ItemStack, ?> entityMetadata) {
    }
}

