/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import java.util.Collections;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class HelpCommand
extends GeyserCommand {
    private final GeyserImpl geyser;
    private final String baseCommand;
    private final Map<String, Command> commands;

    public HelpCommand(GeyserImpl geyser, String name, String description, String permission, String baseCommand, Map<String, Command> commands) {
        super(name, description, permission);
        this.geyser = geyser;
        this.baseCommand = baseCommand;
        this.commands = commands;
        this.setAliases(Collections.singletonList("?"));
    }

    @Override
    public void execute(GeyserSession session, GeyserCommandSource sender, String[] args) {
        int page = 1;
        int maxPage = 1;
        String translationKey = this.baseCommand.equals("geyser") ? "geyser.commands.help.header" : "geyser.commands.extensions.header";
        String header = GeyserLocale.getPlayerLocaleString(translationKey, sender.locale(), page, maxPage);
        sender.sendMessage(header);
        this.commands.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            Command cmd = (Command)entry.getValue();
            if (this.geyser.getPlatformType() == PlatformType.STANDALONE || sender.hasPermission(cmd.permission())) {
                if (cmd.isBedrockOnly() && session == null) {
                    return;
                }
                sender.sendMessage("\u00a7e/" + this.baseCommand + " " + (String)entry.getKey() + "\u00a7f: " + GeyserLocale.getPlayerLocaleString(cmd.description(), sender.locale()));
            }
        });
    }
}

