/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.netty.codec.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.Objects;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.compat.BedrockCompat;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.UnknownPacket;

public abstract class BedrockPacketCodec
extends MessageToMessageCodec<ByteBuf, BedrockPacketWrapper> {
    public static final String NAME = "bedrock-packet-codec";
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockPacketCodec.class);
    private BedrockCodec codec = BedrockCompat.CODEC;
    private BedrockCodecHelper helper = this.codec.createHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void encode(ChannelHandlerContext ctx, BedrockPacketWrapper msg, List<Object> out) throws Exception {
        if (msg.getPacketBuffer() != null) {
            out.add((Object)msg.retain());
        } else {
            ByteBuf buf = ctx.alloc().buffer(128);
            try {
                BedrockPacket packet = msg.getPacket();
                msg.setPacketId(this.getPacketId(packet));
                this.encodeHeader(buf, msg);
                this.codec.tryEncode(this.helper, buf, packet);
                msg.setPacketBuffer(buf.retain());
                out.add((Object)msg.retain());
            }
            catch (Throwable t) {
                log.error("Error encoding packet {}", (Object)msg.getPacket(), (Object)t);
            }
            finally {
                buf.release();
            }
        }
    }

    protected final void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        BedrockPacketWrapper wrapper = new BedrockPacketWrapper();
        wrapper.setPacketBuffer(msg.retainedSlice());
        try {
            int index = msg.readerIndex();
            this.decodeHeader(msg, wrapper);
            wrapper.setHeaderLength(msg.readerIndex() - index);
            wrapper.setPacket(this.codec.tryDecode(this.helper, msg, wrapper.getPacketId()));
            out.add((Object)wrapper.retain());
        }
        catch (Throwable t) {
            log.info("Failed to decode packet", t);
            throw t;
        }
        finally {
            wrapper.release();
        }
    }

    public abstract void encodeHeader(ByteBuf var1, BedrockPacketWrapper var2);

    public abstract void decodeHeader(ByteBuf var1, BedrockPacketWrapper var2);

    public final int getPacketId(BedrockPacket packet) {
        if (packet instanceof UnknownPacket) {
            return ((UnknownPacket)packet).getPacketId();
        }
        return this.codec.getPacketDefinition(packet.getClass()).getId();
    }

    public final void setCodec(BedrockCodec codec) {
        this.codec = Objects.requireNonNull(codec, "Codec cannot be null");
        this.helper = codec.createHelper();
    }

    public final BedrockCodec getCodec() {
        return this.codec;
    }

    public BedrockCodecHelper getHelper() {
        return this.helper;
    }
}

