/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.inventory.transaction;

import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventorySource;

public final class InventoryActionData {
    private final InventorySource source;
    private final int slot;
    private final ItemData fromItem;
    private final ItemData toItem;
    private final int stackNetworkId;

    public InventoryActionData(InventorySource source, int slot, ItemData fromItem, ItemData toItem) {
        this(source, slot, fromItem, toItem, 0);
    }

    public InventoryActionData reverse() {
        return new InventoryActionData(this.source, this.slot, this.toItem, this.fromItem, this.stackNetworkId);
    }

    public InventorySource getSource() {
        return this.source;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemData getFromItem() {
        return this.fromItem;
    }

    public ItemData getToItem() {
        return this.toItem;
    }

    public int getStackNetworkId() {
        return this.stackNetworkId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryActionData)) {
            return false;
        }
        InventoryActionData other = (InventoryActionData)o;
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.getStackNetworkId() != other.getStackNetworkId()) {
            return false;
        }
        InventorySource this$source = this.getSource();
        InventorySource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        ItemData this$fromItem = this.getFromItem();
        ItemData other$fromItem = other.getFromItem();
        if (this$fromItem == null ? other$fromItem != null : !this$fromItem.equals(other$fromItem)) {
            return false;
        }
        ItemData this$toItem = this.getToItem();
        ItemData other$toItem = other.getToItem();
        return !(this$toItem == null ? other$toItem != null : !this$toItem.equals(other$toItem));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        result = result * 59 + this.getStackNetworkId();
        InventorySource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        ItemData $fromItem = this.getFromItem();
        result = result * 59 + ($fromItem == null ? 43 : $fromItem.hashCode());
        ItemData $toItem = this.getToItem();
        result = result * 59 + ($toItem == null ? 43 : $toItem.hashCode());
        return result;
    }

    public String toString() {
        return "InventoryActionData(source=" + this.getSource() + ", slot=" + this.getSlot() + ", fromItem=" + this.getFromItem() + ", toItem=" + this.getToItem() + ", stackNetworkId=" + this.getStackNetworkId() + ")";
    }

    public InventoryActionData(InventorySource source, int slot, ItemData fromItem, ItemData toItem, int stackNetworkId) {
        this.source = source;
        this.slot = slot;
        this.fromItem = fromItem;
        this.toItem = toItem;
        this.stackNetworkId = stackNetworkId;
    }
}

