/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector4d;
import org.cloudburstmc.math.vector.Vector4i;
import org.cloudburstmc.math.vector.Vector4l;
import org.cloudburstmc.math.vector.VectorNf;
import org.cloudburstmc.math.vector.Vectorf;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector4f
implements Vectorf,
Comparable<Vector4f>,
Serializable,
Cloneable {
    public static final Vector4f ZERO = Vector4f.from(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_X = Vector4f.from(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Y = Vector4f.from(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Z = Vector4f.from(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4f UNIT_W = Vector4f.from(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Vector4f ONE = Vector4f.from(1.0f, 1.0f, 1.0f, 1.0f);

    public abstract float getX();

    public abstract float getY();

    public abstract float getZ();

    public abstract float getW();

    public int getFloorX() {
        return GenericMath.floor(this.getX());
    }

    public int getFloorY() {
        return GenericMath.floor(this.getY());
    }

    public int getFloorZ() {
        return GenericMath.floor(this.getZ());
    }

    public int getFloorW() {
        return GenericMath.floor(this.getW());
    }

    @Nonnull
    public Vector4f add(Vector4f v) {
        return this.add(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4f add(double x, double y, double z, double w) {
        return this.add((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Vector4f add(float var1, float var2, float var3, float var4);

    @Nonnull
    public Vector4f sub(Vector4f v) {
        return this.sub(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4f sub(double x, double y, double z, double w) {
        return this.sub((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Vector4f sub(float var1, float var2, float var3, float var4);

    @Nonnull
    public Vector4f mul(double a) {
        return this.mul((float)a);
    }

    @Override
    @Nonnull
    public Vector4f mul(float a) {
        return this.mul(a, a, a, a);
    }

    @Nonnull
    public Vector4f mul(Vector4f v) {
        return this.mul(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4f mul(double x, double y, double z, double w) {
        return this.mul((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Vector4f mul(float var1, float var2, float var3, float var4);

    @Nonnull
    public Vector4f div(double a) {
        return this.div((float)a);
    }

    @Override
    @Nonnull
    public Vector4f div(float a) {
        return this.div(a, a, a, a);
    }

    @Nonnull
    public Vector4f div(Vector4f v) {
        return this.div(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4f div(double x, double y, double z, double w) {
        return this.div((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Vector4f div(float var1, float var2, float var3, float var4);

    public float dot(Vector4f v) {
        return this.dot(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public float dot(double x, double y, double z, double w) {
        return this.dot((float)x, (float)y, (float)z, (float)w);
    }

    public float dot(float x, float y, float z, float w) {
        return this.getX() * x + this.getY() * y + this.getZ() * z + this.getW() * w;
    }

    @Nonnull
    public Vector4f project(Vector4f v) {
        return this.project(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4f project(double x, double y, double z, double w) {
        return this.project((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Vector4f project(float var1, float var2, float var3, float var4);

    @Nonnull
    public Vector4f pow(double pow) {
        return this.pow((float)pow);
    }

    @Override
    @Nonnull
    public abstract Vector4f pow(float var1);

    @Override
    @Nonnull
    public abstract Vector4f ceil();

    @Override
    @Nonnull
    public abstract Vector4f floor();

    @Override
    @Nonnull
    public abstract Vector4f round();

    @Override
    @Nonnull
    public abstract Vector4f abs();

    @Override
    @Nonnull
    public abstract Vector4f negate();

    @Nonnull
    public Vector4f min(Vector4f v) {
        return this.min(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4f min(double x, double y, double z, double w) {
        return this.min((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Vector4f min(float var1, float var2, float var3, float var4);

    @Nonnull
    public Vector4f max(Vector4f v) {
        return this.max(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4f max(double x, double y, double z, double w) {
        return this.max((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Vector4f max(float var1, float var2, float var3, float var4);

    public float distanceSquared(Vector4f v) {
        return this.distanceSquared(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public float distanceSquared(double x, double y, double z, double w) {
        return this.distanceSquared((float)x, (float)y, (float)z, (float)w);
    }

    public float distanceSquared(float x, float y, float z, float w) {
        float dx = this.getX() - x;
        float dy = this.getY() - y;
        float dz = this.getZ() - z;
        float dw = this.getW() - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public float distance(Vector4f v) {
        return this.distance(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public float distance(double x, double y, double z, double w) {
        return this.distance((float)x, (float)y, (float)z, (float)w);
    }

    public float distance(float x, float y, float z, float w) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    @Override
    public float lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ() + this.getW() * this.getW();
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Vector4f normalize();

    @Override
    public int getMinAxis() {
        float value = this.getX();
        int axis = 0;
        if (this.getY() < value) {
            value = this.getY();
            axis = 1;
        }
        if (this.getZ() < value) {
            value = this.getZ();
            axis = 2;
        }
        if (this.getW() < value) {
            axis = 3;
        }
        return axis;
    }

    @Override
    public int getMaxAxis() {
        float value = this.getX();
        int axis = 0;
        if (this.getY() > value) {
            value = this.getY();
            axis = 1;
        }
        if (this.getZ() > value) {
            value = this.getZ();
            axis = 2;
        }
        if (this.getW() > value) {
            axis = 3;
        }
        return axis;
    }

    @Nonnull
    public Vector2f toVector2() {
        return Vector2f.from(this);
    }

    @Nonnull
    public Vector3f toVector3() {
        return Vector3f.from(this);
    }

    @Nonnull
    public VectorNf toVectorN() {
        return VectorNf.from(this);
    }

    @Override
    @Nonnull
    public float[] toArray() {
        return new float[]{this.getX(), this.getY(), this.getZ(), this.getW()};
    }

    @Override
    @Nonnull
    public Vector4i toInt() {
        return Vector4i.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4l toLong() {
        return Vector4l.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4f toFloat() {
        return Vector4f.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4d toDouble() {
        return Vector4d.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    public int compareTo(Vector4f v) {
        return (int)Math.signum(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector4f clone() {
        return Vector4f.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ", " + this.getW() + ")";
    }

    @Nonnull
    public static Vector4f from(float n) {
        return Vector4f.from(n, n, n, n);
    }

    @Nonnull
    public static Vector4f from(Vector2f v) {
        return Vector4f.from(v, 0.0f, 0.0f);
    }

    @Nonnull
    public static Vector4f from(Vector2f v, double z, double w) {
        return Vector4f.from(v, (float)z, (float)w);
    }

    @Nonnull
    public static Vector4f from(Vector2f v, float z, float w) {
        return Vector4f.from(v.getX(), v.getY(), z, w);
    }

    @Nonnull
    public static Vector4f from(Vector3f v) {
        return Vector4f.from(v, 0.0f);
    }

    @Nonnull
    public static Vector4f from(Vector3f v, double w) {
        return Vector4f.from(v, (float)w);
    }

    @Nonnull
    public static Vector4f from(Vector3f v, float w) {
        return Vector4f.from(v.getX(), v.getY(), v.getZ(), w);
    }

    @Nonnull
    public static Vector4f from(Vector4f v) {
        return Vector4f.from(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public static Vector4f from(VectorNf v) {
        return Vector4f.from(v.get(0), v.get(1), v.size() > 2 ? v.get(2) : 0.0f, v.size() > 3 ? v.get(3) : 0.0f);
    }

    @Nonnull
    public static Vector4f from(double x, double y, double z, double w) {
        return Vector4f.from((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public static Vector4f from(float x, float y, float z, float w) {
        return Vectors.createVector4f(x, y, z, w);
    }
}

