/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.level.notify.DemoMessageValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.ElderGuardianEffectValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.EnterCreditsValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.GameEvent;
import com.github.steveice10.mc.protocol.data.game.level.notify.GameEventValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.LimitedCraftingValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.RainStrengthValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.RespawnScreenValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.ThunderStrengthValue;
import io.netty.buffer.ByteBuf;
import lombok.NonNull;

public class ClientboundGameEventPacket
implements MinecraftPacket {
    @NonNull
    private final GameEvent notification;
    private final GameEventValue value;

    public ClientboundGameEventPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.notification = GameEvent.from(in.readUnsignedByte());
        float value = in.readFloat();
        this.value = this.notification == GameEvent.AFFECTED_BY_ELDER_GUARDIAN ? new ElderGuardianEffectValue(value) : (this.notification == GameEvent.CHANGE_GAMEMODE ? GameMode.byId((int)value) : (this.notification == GameEvent.DEMO_MESSAGE ? DemoMessageValue.from((int)value) : (this.notification == GameEvent.ENTER_CREDITS ? EnterCreditsValue.from((int)value) : (this.notification == GameEvent.ENABLE_RESPAWN_SCREEN ? RespawnScreenValue.from((int)value) : (this.notification == GameEvent.LIMITED_CRAFTING ? LimitedCraftingValue.from((int)value) : (this.notification == GameEvent.RAIN_STRENGTH ? new RainStrengthValue(value) : (this.notification == GameEvent.THUNDER_STRENGTH ? new ThunderStrengthValue(value) : null)))))));
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeByte(this.notification.ordinal());
        float value = 0.0f;
        if (this.value instanceof DemoMessageValue) {
            value = ((DemoMessageValue)this.value).getId();
        } else if (this.value instanceof Enum) {
            value = ((Enum)((Object)this.value)).ordinal();
        } else if (this.value instanceof RainStrengthValue) {
            value = ((RainStrengthValue)this.value).getStrength();
        } else if (this.value instanceof ThunderStrengthValue) {
            value = ((ThunderStrengthValue)this.value).getStrength();
        }
        out.writeFloat(value);
    }

    @NonNull
    public GameEvent getNotification() {
        return this.notification;
    }

    public GameEventValue getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundGameEventPacket)) {
            return false;
        }
        ClientboundGameEventPacket other = (ClientboundGameEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GameEvent this$notification = this.getNotification();
        GameEvent other$notification = other.getNotification();
        if (this$notification == null ? other$notification != null : !((Object)((Object)this$notification)).equals((Object)other$notification)) {
            return false;
        }
        GameEventValue this$value = this.getValue();
        GameEventValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundGameEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GameEvent $notification = this.getNotification();
        result = result * 59 + ($notification == null ? 43 : ((Object)((Object)$notification)).hashCode());
        GameEventValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundGameEventPacket(notification=" + this.getNotification() + ", value=" + this.getValue() + ")";
    }

    public ClientboundGameEventPacket withNotification(@NonNull GameEvent notification) {
        if (notification == null) {
            throw new NullPointerException("notification is marked non-null but is null");
        }
        return this.notification == notification ? this : new ClientboundGameEventPacket(notification, this.value);
    }

    public ClientboundGameEventPacket withValue(GameEventValue value) {
        return this.value == value ? this : new ClientboundGameEventPacket(this.notification, value);
    }

    public ClientboundGameEventPacket(@NonNull GameEvent notification, GameEventValue value) {
        if (notification == null) {
            throw new NullPointerException("notification is marked non-null but is null");
        }
        this.notification = notification;
        this.value = value;
    }
}

