/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.Attribute;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeModifier;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeType;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ClientboundUpdateAttributesPacket
implements MinecraftPacket {
    private final int entityId;
    @NonNull
    private final List<Attribute> attributes;

    public ClientboundUpdateAttributesPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = helper.readVarInt(in);
        this.attributes = new ArrayList<Attribute>();
        int length = helper.readVarInt(in);
        for (int index = 0; index < length; ++index) {
            String key = helper.readString(in);
            double value = in.readDouble();
            ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
            int len = helper.readVarInt(in);
            for (int ind = 0; ind < len; ++ind) {
                modifiers.add(new AttributeModifier(helper.readUUID(in), in.readDouble(), helper.readModifierOperation(in)));
            }
            AttributeType type = AttributeType.Builtin.BUILTIN.computeIfAbsent(Identifier.formalize(key), AttributeType.Custom::new);
            this.attributes.add(new Attribute(type, value, modifiers));
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityId);
        helper.writeVarInt(out, this.attributes.size());
        for (Attribute attribute : this.attributes) {
            helper.writeString(out, attribute.getType().getIdentifier());
            out.writeDouble(attribute.getValue());
            helper.writeVarInt(out, attribute.getModifiers().size());
            for (AttributeModifier modifier : attribute.getModifiers()) {
                helper.writeUUID(out, modifier.getUuid());
                out.writeDouble(modifier.getAmount());
                helper.writeModifierOperation(out, modifier.getOperation());
            }
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateAttributesPacket)) {
            return false;
        }
        ClientboundUpdateAttributesPacket other = (ClientboundUpdateAttributesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        List<Attribute> this$attributes = this.getAttributes();
        List<Attribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateAttributesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        List<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateAttributesPacket(entityId=" + this.getEntityId() + ", attributes=" + this.getAttributes() + ")";
    }

    public ClientboundUpdateAttributesPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundUpdateAttributesPacket(entityId, this.attributes);
    }

    public ClientboundUpdateAttributesPacket withAttributes(@NonNull List<Attribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return this.attributes == attributes ? this : new ClientboundUpdateAttributesPacket(this.entityId, attributes);
    }

    public ClientboundUpdateAttributesPacket(int entityId, @NonNull List<Attribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.entityId = entityId;
        this.attributes = attributes;
    }
}

