/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import org.cloudburstmc.math.vector.Vector3d;
import org.jetbrains.annotations.Nullable;

public class ClientboundDamageEventPacket
implements MinecraftPacket {
    private final int entityId;
    private final int sourceTypeId;
    private final int sourceCauseId;
    private final int sourceDirectId;
    @Nullable
    private final Vector3d sourcePosition;

    public ClientboundDamageEventPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.entityId = helper.readVarInt(in);
        this.sourceTypeId = helper.readVarInt(in);
        this.sourceCauseId = helper.readVarInt(in) - 1;
        this.sourceDirectId = helper.readVarInt(in) - 1;
        this.sourcePosition = in.readBoolean() ? Vector3d.from(in.readDouble(), in.readDouble(), in.readDouble()) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.entityId);
        helper.writeVarInt(out, this.sourceTypeId);
        helper.writeVarInt(out, this.sourceCauseId + 1);
        helper.writeVarInt(out, this.sourceDirectId + 1);
        if (this.sourcePosition != null) {
            out.writeBoolean(true);
            out.writeDouble(this.sourcePosition.getX());
            out.writeDouble(this.sourcePosition.getY());
            out.writeDouble(this.sourcePosition.getZ());
        } else {
            out.writeBoolean(false);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getSourceTypeId() {
        return this.sourceTypeId;
    }

    public int getSourceCauseId() {
        return this.sourceCauseId;
    }

    public int getSourceDirectId() {
        return this.sourceDirectId;
    }

    @Nullable
    public Vector3d getSourcePosition() {
        return this.sourcePosition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundDamageEventPacket)) {
            return false;
        }
        ClientboundDamageEventPacket other = (ClientboundDamageEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getSourceTypeId() != other.getSourceTypeId()) {
            return false;
        }
        if (this.getSourceCauseId() != other.getSourceCauseId()) {
            return false;
        }
        if (this.getSourceDirectId() != other.getSourceDirectId()) {
            return false;
        }
        Vector3d this$sourcePosition = this.getSourcePosition();
        Vector3d other$sourcePosition = other.getSourcePosition();
        return !(this$sourcePosition == null ? other$sourcePosition != null : !this$sourcePosition.equals(other$sourcePosition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundDamageEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getSourceTypeId();
        result = result * 59 + this.getSourceCauseId();
        result = result * 59 + this.getSourceDirectId();
        Vector3d $sourcePosition = this.getSourcePosition();
        result = result * 59 + ($sourcePosition == null ? 43 : $sourcePosition.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundDamageEventPacket(entityId=" + this.getEntityId() + ", sourceTypeId=" + this.getSourceTypeId() + ", sourceCauseId=" + this.getSourceCauseId() + ", sourceDirectId=" + this.getSourceDirectId() + ", sourcePosition=" + this.getSourcePosition() + ")";
    }

    public ClientboundDamageEventPacket(int entityId, int sourceTypeId, int sourceCauseId, int sourceDirectId, @Nullable Vector3d sourcePosition) {
        this.entityId = entityId;
        this.sourceTypeId = sourceTypeId;
        this.sourceCauseId = sourceCauseId;
        this.sourceDirectId = sourceDirectId;
        this.sourcePosition = sourcePosition;
    }
}

