/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerSpawnInfo;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundLoginPacket
implements MinecraftPacket {
    private final int entityId;
    private final boolean hardcore;
    @NonNull
    private final String[] worldNames;
    private final int maxPlayers;
    private final int viewDistance;
    private final int simulationDistance;
    private final boolean reducedDebugInfo;
    private final boolean enableRespawnScreen;
    private final boolean doLimitedCrafting;
    private final PlayerSpawnInfo commonPlayerSpawnInfo;

    public ClientboundLoginPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = in.readInt();
        this.hardcore = in.readBoolean();
        int worldCount = helper.readVarInt(in);
        this.worldNames = new String[worldCount];
        for (int i = 0; i < worldCount; ++i) {
            this.worldNames[i] = helper.readString(in);
        }
        this.maxPlayers = helper.readVarInt(in);
        this.viewDistance = helper.readVarInt(in);
        this.simulationDistance = helper.readVarInt(in);
        this.reducedDebugInfo = in.readBoolean();
        this.enableRespawnScreen = in.readBoolean();
        this.doLimitedCrafting = in.readBoolean();
        this.commonPlayerSpawnInfo = helper.readPlayerSpawnInfo(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeInt(this.entityId);
        out.writeBoolean(this.hardcore);
        helper.writeVarInt(out, this.worldNames.length);
        for (String worldName : this.worldNames) {
            helper.writeString(out, worldName);
        }
        helper.writeVarInt(out, this.maxPlayers);
        helper.writeVarInt(out, this.viewDistance);
        helper.writeVarInt(out, this.simulationDistance);
        out.writeBoolean(this.reducedDebugInfo);
        out.writeBoolean(this.enableRespawnScreen);
        out.writeBoolean(this.doLimitedCrafting);
        helper.writePlayerSpawnInfo(out, this.commonPlayerSpawnInfo);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    @NonNull
    public String[] getWorldNames() {
        return this.worldNames;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean isEnableRespawnScreen() {
        return this.enableRespawnScreen;
    }

    public boolean isDoLimitedCrafting() {
        return this.doLimitedCrafting;
    }

    public PlayerSpawnInfo getCommonPlayerSpawnInfo() {
        return this.commonPlayerSpawnInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLoginPacket)) {
            return false;
        }
        ClientboundLoginPacket other = (ClientboundLoginPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.isHardcore() != other.isHardcore()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getSimulationDistance() != other.getSimulationDistance()) {
            return false;
        }
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) {
            return false;
        }
        if (this.isEnableRespawnScreen() != other.isEnableRespawnScreen()) {
            return false;
        }
        if (this.isDoLimitedCrafting() != other.isDoLimitedCrafting()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getWorldNames(), other.getWorldNames())) {
            return false;
        }
        PlayerSpawnInfo this$commonPlayerSpawnInfo = this.getCommonPlayerSpawnInfo();
        PlayerSpawnInfo other$commonPlayerSpawnInfo = other.getCommonPlayerSpawnInfo();
        return !(this$commonPlayerSpawnInfo == null ? other$commonPlayerSpawnInfo != null : !((Object)this$commonPlayerSpawnInfo).equals(other$commonPlayerSpawnInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundLoginPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + (this.isHardcore() ? 79 : 97);
        result = result * 59 + this.getMaxPlayers();
        result = result * 59 + this.getViewDistance();
        result = result * 59 + this.getSimulationDistance();
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * 59 + (this.isEnableRespawnScreen() ? 79 : 97);
        result = result * 59 + (this.isDoLimitedCrafting() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getWorldNames());
        PlayerSpawnInfo $commonPlayerSpawnInfo = this.getCommonPlayerSpawnInfo();
        result = result * 59 + ($commonPlayerSpawnInfo == null ? 43 : ((Object)$commonPlayerSpawnInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundLoginPacket(entityId=" + this.getEntityId() + ", hardcore=" + this.isHardcore() + ", worldNames=" + Arrays.deepToString(this.getWorldNames()) + ", maxPlayers=" + this.getMaxPlayers() + ", viewDistance=" + this.getViewDistance() + ", simulationDistance=" + this.getSimulationDistance() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", enableRespawnScreen=" + this.isEnableRespawnScreen() + ", doLimitedCrafting=" + this.isDoLimitedCrafting() + ", commonPlayerSpawnInfo=" + this.getCommonPlayerSpawnInfo() + ")";
    }

    public ClientboundLoginPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundLoginPacket(entityId, this.hardcore, this.worldNames, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withHardcore(boolean hardcore) {
        return this.hardcore == hardcore ? this : new ClientboundLoginPacket(this.entityId, hardcore, this.worldNames, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withWorldNames(@NonNull String[] worldNames) {
        if (worldNames == null) {
            throw new NullPointerException("worldNames is marked non-null but is null");
        }
        return this.worldNames == worldNames ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, worldNames, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withMaxPlayers(int maxPlayers) {
        return this.maxPlayers == maxPlayers ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.worldNames, maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withViewDistance(int viewDistance) {
        return this.viewDistance == viewDistance ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.worldNames, this.maxPlayers, viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withSimulationDistance(int simulationDistance) {
        return this.simulationDistance == simulationDistance ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.worldNames, this.maxPlayers, this.viewDistance, simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withReducedDebugInfo(boolean reducedDebugInfo) {
        return this.reducedDebugInfo == reducedDebugInfo ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.worldNames, this.maxPlayers, this.viewDistance, this.simulationDistance, reducedDebugInfo, this.enableRespawnScreen, this.doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withEnableRespawnScreen(boolean enableRespawnScreen) {
        return this.enableRespawnScreen == enableRespawnScreen ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.worldNames, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, enableRespawnScreen, this.doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withDoLimitedCrafting(boolean doLimitedCrafting) {
        return this.doLimitedCrafting == doLimitedCrafting ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.worldNames, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, doLimitedCrafting, this.commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket withCommonPlayerSpawnInfo(PlayerSpawnInfo commonPlayerSpawnInfo) {
        return this.commonPlayerSpawnInfo == commonPlayerSpawnInfo ? this : new ClientboundLoginPacket(this.entityId, this.hardcore, this.worldNames, this.maxPlayers, this.viewDistance, this.simulationDistance, this.reducedDebugInfo, this.enableRespawnScreen, this.doLimitedCrafting, commonPlayerSpawnInfo);
    }

    public ClientboundLoginPacket(int entityId, boolean hardcore, @NonNull String[] worldNames, int maxPlayers, int viewDistance, int simulationDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, boolean doLimitedCrafting, PlayerSpawnInfo commonPlayerSpawnInfo) {
        if (worldNames == null) {
            throw new NullPointerException("worldNames is marked non-null but is null");
        }
        this.entityId = entityId;
        this.hardcore = hardcore;
        this.worldNames = worldNames;
        this.maxPlayers = maxPlayers;
        this.viewDistance = viewDistance;
        this.simulationDistance = simulationDistance;
        this.reducedDebugInfo = reducedDebugInfo;
        this.enableRespawnScreen = enableRespawnScreen;
        this.doLimitedCrafting = doLimitedCrafting;
        this.commonPlayerSpawnInfo = commonPlayerSpawnInfo;
    }
}

