/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.activation_range.ActivationRange;
import me.wesley1808.servercore.common.config.ConfigEntry;
import me.wesley1808.servercore.common.config.tables.ActivationRangeConfig;
import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.config.tables.DynamicConfig;
import me.wesley1808.servercore.common.config.tables.EntityLimitConfig;
import me.wesley1808.servercore.common.config.tables.FeatureConfig;
import me.wesley1808.servercore.common.config.tables.OptimizationConfig;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.services.platform.PlatformHelper;
import org.jetbrains.annotations.Nullable;

public class Config {
    @Nullable
    private static final GenericBuilder<CommentedConfig, CommentedFileConfig> CONFIG_BUILDER;
    private static boolean dirty;

    public static void load(boolean afterMixinLoad) {
        if (CONFIG_BUILDER != null) {
            try {
                CommentedFileConfig config = (CommentedFileConfig)CONFIG_BUILDER.build();
                config.load();
                config.close();
                for (Table table : Table.values()) {
                    Config.validate(table, config);
                    if (!afterMixinLoad && !table.loadBeforeMixins) continue;
                    Config.loadEntries((CommentedConfig)config.get(table.key), table.clazz);
                }
                if (afterMixinLoad) {
                    Config.loadChanges();
                }
            }
            catch (Throwable throwable) {
                ServerCore.LOGGER.error("[ServerCore] An error occurred whilst loading the config!", throwable);
            }
        }
    }

    public static void save() {
        Config.save(false);
    }

    public static void save(boolean force) {
        if (CONFIG_BUILDER != null && (dirty || force)) {
            try {
                CommentedFileConfig config = (CommentedFileConfig)CONFIG_BUILDER.build();
                for (Table table : Table.values()) {
                    Config.validate(table, config);
                    Config.saveEntries((CommentedConfig)config.get(table.key), table.clazz);
                    config.setComment(table.key, table.comment);
                }
                config.save();
                config.close();
                dirty = false;
            }
            catch (Throwable throwable) {
                ServerCore.LOGGER.error("[ServerCore] An error occurred whilst saving the config!", throwable);
            }
        }
    }

    public static boolean isConfigAvailable() {
        return CONFIG_BUILDER != null;
    }

    public static void setDirty() {
        dirty = true;
    }

    public static void loadChanges() {
        DynamicSetting.loadCustomOrder();
        ActivationRange.reload();
    }

    private static void validate(Table table, CommentedFileConfig config) {
        if (!config.contains(table.key)) {
            config.add(table.key, (Object)CommentedConfig.inMemory());
        }
    }

    private static void loadEntries(CommentedConfig config, Class<?> clazz) throws IllegalAccessException {
        Config.forEachEntry(clazz, (field, entry) -> {
            String key = field.getName().toLowerCase();
            Object value = config.getOrElse(key, entry.getDefault());
            if (!entry.set(value)) {
                ServerCore.LOGGER.error("[ServerCore] Invalid config entry found! {} = {} (Reverting back to default: {})", new Object[]{key, value, entry.getDefault()});
            }
        });
    }

    private static void saveEntries(CommentedConfig config, Class<?> clazz) throws IllegalAccessException {
        config.clear();
        Config.forEachEntry(clazz, (field, entry) -> {
            String key = field.getName().toLowerCase();
            String comment = entry.getComment();
            config.set(key, entry.get());
            if (comment != null) {
                config.setComment(key, " " + comment.replace("\n", "\n "));
            }
        });
    }

    public static <T> void forEachEntry(Class<?> clazz, BiConsumer<Field, ConfigEntry<T>> consumer) throws IllegalAccessException {
        for (Field field : clazz.getFields()) {
            Object object = field.get(clazz);
            if (!(object instanceof ConfigEntry)) continue;
            ConfigEntry entry = (ConfigEntry)object;
            consumer.accept(field, entry);
        }
    }

    static {
        GenericBuilder builder;
        dirty = false;
        System.setProperty("nightconfig.preserveInsertionOrder", "true");
        Path path = PlatformHelper.getConfigDir().resolve("servercore.toml");
        try {
            builder = CommentedFileConfig.builder((Path)path, (ConfigFormat)TomlFormat.instance()).preserveInsertionOrder().sync();
        }
        catch (Throwable throwable) {
            ServerCore.LOGGER.error("[ServerCore] Unable to initialize config builder: {}", (Object)throwable.toString());
            ServerCore.LOGGER.error("[ServerCore] Load and save operations on the config file will not be available.");
            builder = null;
        }
        CONFIG_BUILDER = builder;
    }

    public static enum Table {
        FEATURES(FeatureConfig.class, false, "Lets you enable / disable certain features and modify them."),
        DYNAMIC(DynamicConfig.class, false, "Modifies mobcaps, no-chunk-tick, simulation and view-distance depending on the MSPT."),
        BREEDING_CAP(EntityLimitConfig.class, false, "Stops animals / villagers from breeding if there are too many of the same type nearby."),
        OPTIMIZATIONS(OptimizationConfig.class, true, "Allows you to toggle specific optimizations that don't have full vanilla parity.\nThese settings will only take effect after server restarts."),
        COMMANDS(CommandConfig.class, false, "Allows you to disable specific commands and modify the way some of them are formatted."),
        ACTIVATION_RANGE(ActivationRangeConfig.class, false, "Ticks entities less often when they are further away from players.");

        public final String key = this.name().toLowerCase();
        public final String comment;
        public final Class<?> clazz;
        public final boolean loadBeforeMixins;

        private Table(Class<?> clazz, boolean loadBeforeMixins, String comment) {
            this.comment = " " + comment.replace("\n", "\n ");
            this.clazz = clazz;
            this.loadBeforeMixins = loadBeforeMixins;
        }
    }
}

