/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.guice.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.geysermc.floodgate.shadow.guice.internal.util.StackTraceElements;
import org.geysermc.floodgate.shadow.guice.spi.BindingSourceRestriction;

final class ModuleSource {
    private final String moduleClassName;
    private final ModuleSource parent;
    private final BindingSourceRestriction.PermitMap permitMap;
    private final StackTraceElements.InMemoryStackTraceElement[] partialCallStack;

    ModuleSource(Class<?> moduleClass, StackTraceElement[] partialCallStack, BindingSourceRestriction.PermitMap permitMap) {
        this(null, moduleClass, partialCallStack, permitMap);
    }

    private ModuleSource(@Nullable ModuleSource parent, Class<?> moduleClass, StackTraceElement[] partialCallStack, BindingSourceRestriction.PermitMap permitMap) {
        Preconditions.checkNotNull(moduleClass, (Object)"module cannot be null.");
        Preconditions.checkNotNull((Object)partialCallStack, (Object)"partialCallStack cannot be null.");
        this.parent = parent;
        this.moduleClassName = moduleClass.getName();
        this.partialCallStack = StackTraceElements.convertToInMemoryStackTraceElement(partialCallStack);
        this.permitMap = permitMap;
    }

    String getModuleClassName() {
        return this.moduleClassName;
    }

    StackTraceElement[] getPartialCallStack() {
        return StackTraceElements.convertToStackTraceElement(this.partialCallStack);
    }

    int getPartialCallStackSize() {
        return this.partialCallStack.length;
    }

    ModuleSource createChild(Class<?> moduleClass, StackTraceElement[] partialCallStack) {
        return new ModuleSource(this, moduleClass, partialCallStack, this.permitMap);
    }

    ModuleSource getParent() {
        return this.parent;
    }

    List<String> getModuleClassNames() {
        ImmutableList.Builder classNames = ImmutableList.builder();
        ModuleSource current = this;
        while (current != null) {
            String className = current.moduleClassName;
            classNames.add((Object)className);
            current = current.parent;
        }
        return classNames.build();
    }

    int size() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.size() + 1;
    }

    int getStackTraceSize() {
        if (this.parent == null) {
            return this.partialCallStack.length;
        }
        return this.parent.getStackTraceSize() + this.partialCallStack.length;
    }

    StackTraceElement[] getStackTrace() {
        int stackTraceSize = this.getStackTraceSize();
        StackTraceElement[] callStack = new StackTraceElement[stackTraceSize];
        int cursor = 0;
        ModuleSource current = this;
        while (current != null) {
            StackTraceElement[] chunk = StackTraceElements.convertToStackTraceElement(current.partialCallStack);
            int chunkSize = chunk.length;
            System.arraycopy(chunk, 0, callStack, cursor, chunkSize);
            current = current.parent;
            cursor += chunkSize;
        }
        return callStack;
    }

    BindingSourceRestriction.PermitMap getPermitMap() {
        return this.permitMap;
    }
}

