/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.guice.internal;

import java.lang.reflect.Field;
import org.geysermc.floodgate.shadow.guice.internal.BindingImpl;
import org.geysermc.floodgate.shadow.guice.internal.Errors;
import org.geysermc.floodgate.shadow.guice.internal.ErrorsException;
import org.geysermc.floodgate.shadow.guice.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.guice.internal.InternalContext;
import org.geysermc.floodgate.shadow.guice.internal.InternalProvisionException;
import org.geysermc.floodgate.shadow.guice.internal.SingleMemberInjector;
import org.geysermc.floodgate.shadow.guice.spi.Dependency;
import org.geysermc.floodgate.shadow.guice.spi.InjectionPoint;

final class SingleFieldInjector
implements SingleMemberInjector {
    final Field field;
    final InjectionPoint injectionPoint;
    final Dependency<?> dependency;
    final BindingImpl<?> binding;

    public SingleFieldInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        this.field = (Field)injectionPoint.getMember();
        this.dependency = injectionPoint.getDependencies().get(0);
        this.field.setAccessible(true);
        this.binding = injector.getBindingOrThrow(this.dependency.getKey(), errors, InjectorImpl.JitLimitation.NO_JIT);
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(InternalContext context, Object o) throws InternalProvisionException {
        try {
            Object value = this.binding.getInternalFactory().get(context, this.dependency, false);
            this.field.set(o, value);
        }
        catch (InternalProvisionException e) {
            throw e.addSource(this.dependency);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

