/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.guice.internal;

import org.geysermc.floodgate.shadow.guice.Provider;
import org.geysermc.floodgate.shadow.guice.internal.AbstractProcessor;
import org.geysermc.floodgate.shadow.guice.internal.Errors;
import org.geysermc.floodgate.shadow.guice.internal.ErrorsException;
import org.geysermc.floodgate.shadow.guice.internal.MembersInjectorImpl;
import org.geysermc.floodgate.shadow.guice.spi.MembersInjectorLookup;
import org.geysermc.floodgate.shadow.guice.spi.ProviderLookup;

final class LookupProcessor
extends AbstractProcessor {
    LookupProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
        try {
            MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(lookup.getType(), this.errors);
            lookup.initializeDelegate(membersInjector);
            this.injector.getBindingData().putMembersInjectorLookup(lookup);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup) {
        try {
            Provider<T> provider = this.injector.getProviderOrThrow(lookup.getDependency(), this.errors);
            lookup.initializeDelegate(provider);
            this.injector.getBindingData().putProviderLookup(lookup);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }
}

