/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage.channel;

import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.api.player.PropertyKey;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannel;
import org.geysermc.floodgate.shadow.guice.Inject;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinData;

public class SkinChannel
implements PluginMessageChannel {
    @Inject
    private FloodgateApi api;
    @Inject
    private FloodgateConfig config;
    @Inject
    private SkinApplier skinApplier;

    @Override
    public String getIdentifier() {
        return "floodgate:skin";
    }

    @Override
    public PluginMessageChannel.Result handleProxyCall(byte[] data, UUID targetUuid, String targetUsername, PluginMessageChannel.Identity targetIdentity, UUID sourceUuid, String sourceUsername, PluginMessageChannel.Identity sourceIdentity) {
        if (sourceIdentity == PluginMessageChannel.Identity.PLAYER) {
            PluginMessageChannel.Result result = this.handleServerCall(data, targetUuid, targetUsername);
            if (!result.isAllowed() && result.getReason() == null && this.config.isProxy() && ((ProxyFloodgateConfig)this.config).isSendFloodgateData()) {
                return PluginMessageChannel.Result.forward();
            }
            return result;
        }
        if (sourceIdentity == PluginMessageChannel.Identity.SERVER) {
            return PluginMessageChannel.Result.kick("Got skin data from a server?");
        }
        return PluginMessageChannel.Result.handled();
    }

    @Override
    public PluginMessageChannel.Result handleServerCall(byte[] data, UUID targetUuid, String targetUsername) {
        FloodgatePlayer floodgatePlayer = this.api.getPlayer(targetUuid);
        if (floodgatePlayer == null) {
            return PluginMessageChannel.Result.kick("Player sent skins data for a non-Floodgate player");
        }
        String message = new String(data, StandardCharsets.UTF_8);
        String[] split = message.split("\u0000");
        if (split.length != 2) {
            return PluginMessageChannel.Result.kick("Got invalid skin data");
        }
        if (floodgatePlayer.isLinked()) {
            return PluginMessageChannel.Result.handled();
        }
        String value = split[0];
        String signature = split[1];
        JsonObject result = new JsonObject();
        result.addProperty("value", value);
        result.addProperty("signature", signature);
        SkinData skinData = new SkinData(value, signature);
        floodgatePlayer.addProperty(PropertyKey.SKIN_UPLOADED, (Object)skinData);
        this.skinApplier.applySkin(floodgatePlayer, skinData);
        return PluginMessageChannel.Result.handled();
    }
}

