/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.crypto;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import org.geysermc.floodgate.util.InvalidFormatException;

public interface FloodgateCipher {
    public static final int VERSION = 0;
    public static final byte[] IDENTIFIER = "^Floodgate^".getBytes(StandardCharsets.UTF_8);
    public static final byte[] HEADER = (new String(IDENTIFIER, StandardCharsets.UTF_8) + '>').getBytes(StandardCharsets.UTF_8);

    public static int version(String data) {
        if (data.length() <= HEADER.length) {
            return -1;
        }
        for (int i = 0; i < IDENTIFIER.length; ++i) {
            if (IDENTIFIER[i] == data.charAt(i)) continue;
            return -1;
        }
        return data.charAt(IDENTIFIER.length) - 62;
    }

    public void init(Key var1);

    public byte[] encrypt(byte[] var1) throws Exception;

    default public byte[] encryptFromString(String data) throws Exception {
        return this.encrypt(data.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] decrypt(byte[] var1) throws Exception;

    default public String decryptToString(byte[] data) throws Exception {
        byte[] decrypted = this.decrypt(data);
        if (decrypted == null) {
            return null;
        }
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    default public byte[] decryptFromString(String data) throws Exception {
        return this.decrypt(data.getBytes(StandardCharsets.UTF_8));
    }

    default public void checkHeader(byte[] data) throws InvalidFormatException {
        if (data.length <= HEADER.length) {
            throw new InvalidFormatException("Data length is smaller then header.Needed " + HEADER.length + ", got " + data.length);
        }
        for (int i = 0; i < IDENTIFIER.length; ++i) {
            if (IDENTIFIER[i] == data[i]) continue;
            String identifier = new String(IDENTIFIER, StandardCharsets.UTF_8);
            String received = new String(data, 0, IDENTIFIER.length, StandardCharsets.UTF_8);
            throw new InvalidFormatException("Expected identifier " + identifier + ", got " + received);
        }
    }
}

