/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.api;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.util.FormBuilder;
import org.geysermc.floodgate.api.InstanceHolder;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.api.unsafe.Unsafe;

public interface FloodgateApi {
    public static FloodgateApi getInstance() {
        return InstanceHolder.getApi();
    }

    public String getPlayerPrefix();

    public Collection<FloodgatePlayer> getPlayers();

    public int getPlayerCount();

    public boolean isFloodgatePlayer(UUID var1);

    public FloodgatePlayer getPlayer(UUID var1);

    public UUID createJavaPlayerId(long var1);

    public boolean isFloodgateId(UUID var1);

    public boolean sendForm(UUID var1, Form var2);

    public boolean sendForm(UUID var1, org.geysermc.cumulus.form.util.FormBuilder<?, ?, ?> var2);

    @Deprecated
    public boolean sendForm(UUID var1, org.geysermc.cumulus.Form<?> var2);

    @Deprecated
    public boolean sendForm(UUID var1, FormBuilder<?, ?> var2);

    public boolean transferPlayer(UUID var1, String var2, int var3);

    public CompletableFuture<Long> getXuidFor(String var1);

    default public CompletableFuture<UUID> getUuidFor(String gamertag) {
        return this.getXuidFor(gamertag).thenApply(xuid -> {
            if (xuid == null) {
                return null;
            }
            return this.createJavaPlayerId((long)xuid);
        });
    }

    public CompletableFuture<String> getGamertagFor(long var1);

    default public PlayerLink getPlayerLink() {
        return InstanceHolder.getPlayerLink();
    }

    public Unsafe unsafe();
}

