/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.updater;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geysermc.configutils.parser.template.TemplateParseResult;
import org.geysermc.configutils.updater.change.Changes;
import org.geysermc.configutils.updater.file.ConfigFileUpdaterResult;
import org.geysermc.configutils.updater.file.yaml.YamlConfigFileUpdater;
import org.geysermc.configutils.util.Utils;
import org.geysermc.floodgate.shadow.snakeyaml.Yaml;

public class ConfigUpdater {
    public ConfigFileUpdaterResult update(List<String> currentConfig, String configVersionName, TemplateParseResult parseResult, Changes changes, Collection<String> copyDirectly, String ... ignore) {
        String versionString = null;
        for (String configLine : currentConfig) {
            if (!configLine.startsWith(configVersionName + ':')) continue;
            versionString = configLine.substring(configLine.indexOf(58) + 1).trim();
            break;
        }
        Integer version = null;
        if (versionString != null) {
            try {
                version = Integer.parseInt(versionString);
            }
            catch (NumberFormatException e) {
                return ConfigFileUpdaterResult.failed(new IllegalStateException(String.format("Got invalid config version: %s", versionString)));
            }
        }
        if (version == null) {
            version = 0;
        }
        if (version < 0) {
            return ConfigFileUpdaterResult.failed(new IllegalStateException(String.format("Got a negative config version: %s", version)));
        }
        if (!parseResult.succeeded()) {
            return ConfigFileUpdaterResult.failed(new IllegalStateException("Couldn't update the config because we couldn't read the newest config template", parseResult.error()));
        }
        int latestVersion = 0;
        for (String string : parseResult.templateLines()) {
            if (!string.startsWith(configVersionName + ':')) continue;
            latestVersion = Integer.parseInt(string.substring(string.indexOf(58) + 1).trim());
            break;
        }
        if (version > latestVersion) {
            return ConfigFileUpdaterResult.failed(new IllegalStateException("Cannot update a configuration that is newer than the latest available config version"));
        }
        StringBuilder currentConfigBuilder = new StringBuilder();
        for (String line : currentConfig) {
            currentConfigBuilder.append(line).append(System.lineSeparator());
        }
        Map map = (Map)new Yaml().load(currentConfigBuilder.toString());
        if (version == latestVersion) {
            return ConfigFileUpdaterResult.ok(currentConfig, map, Collections.emptySet(), Collections.emptyList());
        }
        changes.select(version, latestVersion);
        return new YamlConfigFileUpdater().update(map, changes, Utils.merge(ignore, configVersionName), copyDirectly, parseResult.templateLines());
    }
}

