/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.parser.template.action;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.configutils.parser.template.action.Action;
import org.geysermc.configutils.parser.template.action.SingleAction;
import org.geysermc.configutils.parser.template.action.register.RootGroup;

public abstract class ActionGroup
implements Action {
    public abstract @NonNull String groupPrefix();

    public abstract @NonNull Action[] children();

    public final @Nullable Pair<String, Action> child(@NonNull String line) {
        Objects.requireNonNull(line);
        if (line.isEmpty()) {
            this.throwIfNotRoot(line);
            return null;
        }
        block0: for (Action child : this.children()) {
            if (child instanceof SingleAction) {
                if (((SingleAction)child).actionPrefix() != line.charAt(0)) continue;
                return new ObjectObjectImmutablePair((Object)line.substring(1), (Object)child);
            }
            if (child instanceof ActionGroup) {
                String prefix = ((ActionGroup)child).groupPrefix();
                if (line.length() < prefix.length()) continue;
                for (int i = 0; i < prefix.length(); ++i) {
                    if (line.charAt(i) != prefix.charAt(i)) continue block0;
                }
                return ((ActionGroup)child).child(line.substring(prefix.length()));
            }
            throw new IllegalStateException("Child has to be an instance of SingleAction or ActionGroup");
        }
        this.throwIfNotRoot(line);
        return null;
    }

    private void throwIfNotRoot(String line) {
        if (!(this instanceof RootGroup)) {
            throw new IllegalStateException(String.format("Cannot find an action that matches '%s' in %s", line, this.getClass().getSimpleName()));
        }
    }
}

