/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyIndexer<T extends Comparable<T>> {
    private static final Map<class_2769<?>, PropertyIndexer<?>> KNOWN_INDEXERS = new Reference2ObjectOpenHashMap();
    private final class_2769<T> property;
    private final int numValues;
    protected final T[] valuesInOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>> PropertyIndexer<T> makeIndexer(class_2769<T> prop) {
        Map<class_2769<?>, PropertyIndexer<?>> map = KNOWN_INDEXERS;
        synchronized (map) {
            PropertyIndexer unchecked = KNOWN_INDEXERS.computeIfAbsent(prop, propInner -> {
                PropertyIndexer result = null;
                if (propInner instanceof class_2746) {
                    class_2746 boolProp = (class_2746)propInner;
                    result = new BoolIndexer(boolProp);
                } else if (propInner instanceof class_2758) {
                    class_2758 intProp = (class_2758)propInner;
                    result = new IntIndexer(intProp);
                } else if (WeirdVanillaDirectionIndexer.isApplicable(propInner)) {
                    result = new WeirdVanillaDirectionIndexer((class_2769<class_2350>)propInner);
                } else if (propInner instanceof class_2754) {
                    class_2754 enumProp = (class_2754)propInner;
                    result = new EnumIndexer(enumProp);
                }
                if (result == null || !result.isValid()) {
                    return new GenericIndexer(propInner);
                }
                return result;
            });
            return unchecked;
        }
    }

    protected PropertyIndexer(class_2769<T> property, T[] valuesInOrder) {
        this.property = property;
        this.numValues = property.method_11898().size();
        this.valuesInOrder = valuesInOrder;
    }

    public class_2769<T> getProperty() {
        return this.property;
    }

    public int numValues() {
        return this.numValues;
    }

    @Nullable
    public final T byIndex(int index) {
        if (index >= 0 && index < this.valuesInOrder.length) {
            return this.valuesInOrder[index];
        }
        return null;
    }

    public abstract int toIndex(T var1);

    protected boolean isValid() {
        Collection allowed = this.getProperty().method_11898();
        int index = 0;
        for (Comparable val : allowed) {
            if (this.toIndex(val) != index || !val.equals(this.byIndex(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static class BoolIndexer
    extends PropertyIndexer<Boolean> {
        private static final Boolean[] VALUES = new Boolean[]{true, false};

        protected BoolIndexer(class_2746 property) {
            super((class_2769)property, (Comparable[])VALUES);
        }

        @Override
        public int toIndex(Boolean value) {
            return value != false ? 0 : 1;
        }
    }

    private static class IntIndexer
    extends PropertyIndexer<Integer> {
        private final int min;

        protected IntIndexer(class_2758 property) {
            super((class_2769)property, (Comparable[])property.method_11898().toArray(new Integer[0]));
            this.min = property.method_11898().stream().min(Comparator.naturalOrder()).orElse(0);
        }

        @Override
        public int toIndex(Integer value) {
            return value - this.min;
        }
    }

    private static class WeirdVanillaDirectionIndexer
    extends PropertyIndexer<class_2350> {
        private static final class_2350[] ORDER = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033};

        public WeirdVanillaDirectionIndexer(class_2769<class_2350> prop) {
            super(prop, (Comparable[])ORDER);
            Preconditions.checkState((boolean)this.isValid());
        }

        static boolean isApplicable(class_2769<?> prop) {
            Collection values = prop.method_11898();
            if (values.size() != ORDER.length) {
                return false;
            }
            return Arrays.equals(ORDER, values.toArray());
        }

        @Override
        public int toIndex(class_2350 value) {
            return switch (value) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11043 -> 0;
                case class_2350.field_11034 -> 1;
                case class_2350.field_11035 -> 2;
                case class_2350.field_11039 -> 3;
                case class_2350.field_11036 -> 4;
                case class_2350.field_11033 -> 5;
            };
        }
    }

    private static class EnumIndexer<E extends Enum<E>>
    extends PropertyIndexer<E> {
        private final int ordinalOffset;

        protected EnumIndexer(class_2754<E> property) {
            super(property, (Comparable[])property.method_11898().toArray(new Enum[0]));
            this.ordinalOffset = property.method_11898().stream().mapToInt(rec$ -> ((Enum)rec$).ordinal()).min().orElse(0);
        }

        @Override
        public int toIndex(E value) {
            return ((Enum)value).ordinal() - this.ordinalOffset;
        }
    }

    private static class GenericIndexer<T extends Comparable<T>>
    extends PropertyIndexer<T> {
        private final Map<Comparable<?>, Integer> toValueIndex;

        protected GenericIndexer(class_2769<T> property) {
            super(property, property.method_11898().toArray(new Comparable[0]));
            ImmutableMap.Builder toValueIndex = ImmutableMap.builder();
            for (int i = 0; i < this.valuesInOrder.length; ++i) {
                toValueIndex.put((Object)this.valuesInOrder[i], (Object)i);
            }
            this.toValueIndex = toValueIndex.build();
        }

        @Override
        public int toIndex(T value) {
            return this.toValueIndex.getOrDefault(value, -1);
        }
    }
}

