/*
 * Decompiled with CFR 0.152.
 */
package org.lanternpowered.lmbda;

import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.relocate.asm.Type;
import org.lanternpowered.lmbda.InternalUtilities;

final class ResolvedLambdaType<@NonNull T> {
    final @NonNull Class<T> functionClass;
    final @Nullable ParameterizedType genericFunctionType;
    final @NonNull Method method;
    final @NonNull MethodType methodType;

    ResolvedLambdaType(@NonNull java.lang.reflect.Type type) {
        Class functionClass;
        ParameterizedType genericFunctionType;
        if (type instanceof Class) {
            genericFunctionType = null;
            functionClass = (Class)type;
        } else if (type instanceof ParameterizedType) {
            genericFunctionType = (ParameterizedType)type;
            functionClass = (Class)genericFunctionType.getRawType();
        } else {
            throw new IllegalStateException("A " + InternalUtilities.getTypeClassName(type) + " can't be a LambdaType.");
        }
        this.method = ResolvedLambdaType.validateClassAndFindMethod(functionClass);
        this.methodType = MethodType.methodType(this.method.getReturnType(), this.method.getParameterTypes());
        this.functionClass = functionClass;
        this.genericFunctionType = genericFunctionType;
    }

    private static @NonNull Method validateClassAndFindMethod(@NonNull Class<?> functionClass) {
        if (Modifier.isPrivate(functionClass.getModifiers())) {
            throw new IllegalStateException("A function class may not be private.");
        }
        if (functionClass.isInterface()) {
            return ResolvedLambdaType.findInterfaceMethod(functionClass);
        }
        if (Modifier.isAbstract(functionClass.getModifiers())) {
            if (functionClass.getEnclosingClass() != null && !Modifier.isStatic(functionClass.getModifiers())) {
                throw new IllegalStateException("A abstract function class may not be a non-static inner class.");
            }
            ResolvedLambdaType.validateConstructors(functionClass);
            return ResolvedLambdaType.findAbstractClassMethod(functionClass);
        }
        throw new IllegalStateException("The function type must be a interface or a abstract class.");
    }

    private static void validateConstructors(@NonNull Class<?> functionClass) {
        Constructor<?>[] constructors = functionClass.getDeclaredConstructors();
        boolean found = false;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterCount() != 0) continue;
            if (Modifier.isPrivate(constructor.getModifiers())) {
                throw new IllegalStateException("The zero arg constructor of a abstract function class must be at least package-private.");
            }
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("A abstract function class must have a zero arg constructor.");
        }
    }

    private static @NonNull Method findAbstractClassMethod(@NonNull Class<?> functionClass) {
        HashMap<String, Method> foundMethods = new HashMap<String, Method>();
        ResolvedLambdaType.findClassMethods(functionClass, foundMethods);
        List methods = foundMethods.values().stream().filter(method -> !Modifier.isStatic(method.getModifiers()) && Modifier.isAbstract(method.getModifiers())).collect(Collectors.toList());
        if (methods.size() > 1) {
            throw new IllegalStateException("Found multiple abstract methods in: " + functionClass.getName());
        }
        if (methods.isEmpty()) {
            throw new IllegalStateException("Couldn't find a abstract method in: " + functionClass.getName());
        }
        return (Method)methods.get(0);
    }

    private static @NonNull String toKey(@NonNull Method method) {
        return method.getName() + ';' + Type.getMethodDescriptor(method);
    }

    private static void findClassMethods(@NonNull Class<?> functionClass, @NonNull Map<String, Method> methods) {
        for (Method method : functionClass.getDeclaredMethods()) {
            methods.putIfAbsent(ResolvedLambdaType.toKey(method), method);
        }
        for (GenericDeclaration genericDeclaration : functionClass.getInterfaces()) {
            ResolvedLambdaType.findClassMethods(genericDeclaration, methods);
        }
        Class<?> superclass = functionClass.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            ResolvedLambdaType.findClassMethods(superclass, methods);
        }
    }

    private static @NonNull Method findInterfaceMethod(@NonNull Class<?> functionClass) {
        Method validMethod = null;
        for (Method method : functionClass.getMethods()) {
            if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
            if (validMethod != null) {
                throw new IllegalStateException("Found multiple non-default methods in: " + functionClass.getName());
            }
            validMethod = method;
        }
        if (validMethod == null) {
            throw new IllegalStateException("Couldn't find a non-default method in: " + functionClass.getName());
        }
        return validMethod;
    }

    @NonNull java.lang.reflect.Type getFunctionType() {
        return this.genericFunctionType != null ? this.genericFunctionType : this.functionClass;
    }

    @NonNull Method getMethodCopy() {
        Object[] parameters = this.method.getParameterTypes();
        for (Method method : this.method.getDeclaringClass().getDeclaredMethods()) {
            if (!method.getName().equals(this.method.getName()) || !method.getReturnType().equals(this.method.getReturnType()) || method.getParameterCount() != parameters.length || !Arrays.equals(method.getParameterTypes(), parameters)) continue;
            return method;
        }
        throw new IllegalStateException();
    }

    public @NonNull String toString() {
        return String.format("LambdaType[type=%s,method=%s]", this.getFunctionType().getTypeName(), this.method.getName() + this.methodType);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ResolvedLambdaType)) {
            return false;
        }
        ResolvedLambdaType that = (ResolvedLambdaType)obj;
        return that.method.equals(this.method) && that.functionClass == this.functionClass && Objects.equals(this.genericFunctionType, that.genericFunctionType);
    }

    public int hashCode() {
        return Objects.hash(this.functionClass, this.method, this.genericFunctionType);
    }
}

