/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util.collection;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.erosion.util.LecternUtils;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.collection.FixedInt2BooleanMap;

public class LecternHasBookMap
extends FixedInt2BooleanMap {
    private static final long serialVersionUID = 1L;

    public void handleBlockChange(GeyserSession session, int blockState, Vector3i position) {
        WorldManager worldManager = session.getGeyser().getWorldManager();
        int offset = blockState - this.start;
        if (offset < 0 || offset >= this.value.length) {
            if (!worldManager.shouldExpectLecternHandled(session)) {
                session.getLecternCache().remove(position);
            }
            return;
        }
        if (worldManager.shouldExpectLecternHandled(session)) {
            worldManager.sendLecternData(session, position.getX(), position.getY(), position.getZ());
        } else {
            boolean newLecternHasBook = this.value[offset];
            if (newLecternHasBook != this.get(worldManager.getBlockAt(session, position))) {
                if (newLecternHasBook) {
                    worldManager.sendLecternData(session, position.getX(), position.getY(), position.getZ());
                } else {
                    session.getLecternCache().remove(position);
                    NbtMap newLecternTag = LecternUtils.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), 0).build();
                    BlockEntityUtils.updateBlockEntity(session, newLecternTag, position);
                }
            }
        }
    }
}

