/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util.collection;

import it.unimi.dsi.fastutil.ints.AbstractInt2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;

public class FixedInt2IntMap
extends AbstractInt2IntMap {
    protected int[] value;
    protected int start = -1;
    private static final long serialVersionUID = 1L;

    public int size() {
        return this.value.length;
    }

    public ObjectSet<Int2IntMap.Entry> int2IntEntrySet() {
        throw new UnsupportedOperationException();
    }

    public int get(int i) {
        return this.getOrDefault(i, this.defRetValue);
    }

    public int getOrDefault(int key, int defaultValue) {
        int offset = key - this.start;
        if (offset < 0 || offset >= this.value.length) {
            return defaultValue;
        }
        return this.value[offset];
    }

    public int put(int key, int value) {
        if (this.start == -1) {
            this.start = key;
            this.value = new int[]{value};
        } else {
            int offset = key - this.start;
            if (offset >= 0 && offset < this.value.length) {
                int curr = this.value[offset];
                this.value[offset] = value;
                return curr;
            }
            if (offset != this.value.length) {
                throw new IndexOutOfBoundsException("Expected: " + (this.value.length + this.start) + ", got " + key);
            }
            int[] newValue = new int[offset + 1];
            System.arraycopy(this.value, 0, newValue, 0, this.value.length);
            this.value = newValue;
            this.value[offset] = value;
        }
        return this.defRetValue;
    }

    public boolean containsKey(int k) {
        int offset = k - this.start;
        return offset >= 0 && offset < this.value.length;
    }

    public boolean containsValue(int v) {
        for (int i : this.value) {
            if (i != v) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        int index = this.start;
        for (int i : this.value) {
            builder.append(index++).append("=>").append(i);
            if (index >= this.value.length + this.start) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }
}

