/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.scoreboard;

import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardPosition;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.scoreboard.ClientboundSetScorePacket;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundSetScorePacket.class)
public class JavaSetScoreTranslator
extends PacketTranslator<ClientboundSetScorePacket> {
    private static final boolean SHOW_SCOREBOARD_LOGS = Boolean.parseBoolean(System.getProperty("Geyser.ShowScoreboardLogs", "true"));
    private final GeyserLogger logger = GeyserImpl.getInstance().getLogger();

    @Override
    public void translate(GeyserSession session, ClientboundSetScorePacket packet) {
        WorldCache worldCache = session.getWorldCache();
        Scoreboard scoreboard = worldCache.getScoreboard();
        int pps = worldCache.increaseAndGetScoreboardPacketsPerSecond();
        Objective objective = scoreboard.getObjective(packet.getObjective());
        if (objective == null) {
            if (SHOW_SCOREBOARD_LOGS) {
                this.logger.info(GeyserLocale.getLocaleStringLog("geyser.network.translator.score.failed_objective", packet.getObjective()));
            }
            return;
        }
        boolean isBelowName = objective == scoreboard.getObjectiveSlots().get((Object)ScoreboardPosition.BELOW_NAME);
        objective.setScore(packet.getOwner(), packet.getValue());
        if (isBelowName) {
            JavaSetScoreTranslator.setBelowName(session, objective, packet.getOwner(), packet.getValue());
        }
        if (pps < ScoreboardUpdater.FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD) {
            scoreboard.onUpdate();
        }
    }

    static void setBelowName(GeyserSession session, Objective objective, String username, int count) {
        PlayerEntity entity = JavaSetScoreTranslator.getOtherPlayerEntity(session, username);
        if (entity == null) {
            return;
        }
        String displayString = count + " " + objective.getDisplayName();
        entity.getDirtyMetadata().put(EntityDataTypes.SCORE, displayString);
        SetEntityDataPacket entityDataPacket = new SetEntityDataPacket();
        entityDataPacket.setRuntimeEntityId(entity.getGeyserId());
        entityDataPacket.getMetadata().put(EntityDataTypes.SCORE, (Object)displayString);
        session.sendUpstreamPacket(entityDataPacket);
    }

    private static @Nullable PlayerEntity getOtherPlayerEntity(GeyserSession session, String username) {
        if (session.getPlayerEntity().getUsername().equals(username)) {
            return null;
        }
        for (PlayerEntity entity : session.getEntityCache().getAllPlayerEntities()) {
            if (!entity.getUsername().equals(username)) continue;
            if (entity.isValid()) {
                return entity;
            }
            return null;
        }
        return null;
    }
}

