/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.player;

import com.github.steveice10.mc.protocol.data.game.entity.RotationOrigin;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player.ClientboundPlayerLookAtPacket;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.MathUtils;

@Translator(packet=ClientboundPlayerLookAtPacket.class)
public class JavaPlayerLookAtTranslator
extends PacketTranslator<ClientboundPlayerLookAtPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundPlayerLookAtPacket packet) {
        Vector3f targetPosition = this.targetPosition(session, packet);
        Vector3f selfPosition = session.getPlayerEntity().getPosition();
        float xDelta = targetPosition.getX() - selfPosition.getX();
        float yDelta = targetPosition.getY() - selfPosition.getY();
        float zDelta = targetPosition.getZ() - selfPosition.getZ();
        double sqrt = Math.sqrt(xDelta * xDelta + zDelta * zDelta);
        float yaw = MathUtils.wrapDegrees(-Math.toDegrees(Math.atan2(yDelta, sqrt)));
        float pitch = MathUtils.wrapDegrees(Math.toDegrees(Math.atan2(zDelta, xDelta)) - 90.0);
        SessionPlayerEntity self = session.getPlayerEntity();
        self.updateRotation(yaw, pitch, yaw, self.isOnGround());
    }

    public Vector3f targetPosition(GeyserSession session, ClientboundPlayerLookAtPacket packet) {
        if (packet.getTargetEntityOrigin() != null) {
            int entityId = packet.getTargetEntityId();
            Entity target = session.getEntityCache().getEntityByJavaId(entityId);
            if (target != null) {
                return switch (packet.getTargetEntityOrigin()) {
                    default -> throw new IncompatibleClassChangeError();
                    case RotationOrigin.FEET -> target.getPosition();
                    case RotationOrigin.EYES -> target.getPosition().add(0.0f, target.getBoundingBoxHeight(), 0.0f);
                };
            }
        }
        return Vector3f.from(packet.getX(), packet.getY(), packet.getZ());
    }
}

