/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Equipment;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.ClientboundSetEquipmentPacket;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.FakeHeadProvider;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundSetEquipmentPacket.class)
public class JavaSetEquipmentTranslator
extends PacketTranslator<ClientboundSetEquipmentPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetEquipmentPacket packet) {
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            session.getGeyser().getLogger().debug("Attempted to add armor to a non-living entity type (" + entity.getDefinition().entityType().name() + ").");
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        boolean armorUpdated = false;
        boolean mainHandUpdated = false;
        boolean offHandUpdated = false;
        block8: for (Equipment equipment : packet.getEquipment()) {
            ItemData item = ItemTranslator.translateToBedrock(session, equipment.getItem());
            switch (equipment.getSlot()) {
                case HELMET: {
                    ItemStack javaItem = equipment.getItem();
                    if (livingEntity instanceof PlayerEntity && javaItem != null && javaItem.getId() == Items.PLAYER_HEAD.javaId() && javaItem.getNbt() != null) {
                        FakeHeadProvider.setHead(session, (PlayerEntity)livingEntity, javaItem.getNbt().get("SkullOwner"));
                    } else {
                        FakeHeadProvider.restoreOriginalSkin(session, livingEntity);
                    }
                    livingEntity.setHelmet(item);
                    armorUpdated = true;
                    continue block8;
                }
                case CHESTPLATE: {
                    livingEntity.setChestplate(item);
                    armorUpdated = true;
                    continue block8;
                }
                case LEGGINGS: {
                    livingEntity.setLeggings(item);
                    armorUpdated = true;
                    continue block8;
                }
                case BOOTS: {
                    livingEntity.setBoots(item);
                    armorUpdated = true;
                    continue block8;
                }
                case MAIN_HAND: {
                    livingEntity.setHand(item);
                    mainHandUpdated = true;
                    continue block8;
                }
                case OFF_HAND: {
                    livingEntity.setOffHand(item);
                    offHandUpdated = true;
                }
            }
        }
        if (armorUpdated) {
            livingEntity.updateArmor(session);
        }
        if (mainHandUpdated) {
            livingEntity.updateMainHand(session);
        }
        if (offHandUpdated) {
            livingEntity.updateOffHand(session);
        }
    }
}

