/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level;

import com.github.steveice10.mc.protocol.data.game.chunk.BitStorage;
import com.github.steveice10.mc.protocol.data.game.chunk.DataPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.GlobalPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.Palette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.SingletonPalette;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.level.chunk.BlockStorage;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.JavaCodecUtil;
import org.geysermc.geyser.util.MathUtils;

public class BiomeTranslator {
    public static void loadServerBiomes(GeyserSession session, CompoundTag codec) {
        Int2IntOpenHashMap biomeTranslations = new Int2IntOpenHashMap();
        CompoundTag worldGen = (CompoundTag)codec.get("minecraft:worldgen/biome");
        ListTag serverBiomes = (ListTag)worldGen.get("value");
        session.setBiomeGlobalPalette(MathUtils.getGlobalPaletteForSize(serverBiomes.size()));
        int greatestBiomeId = 0;
        for (CompoundTag biomeTag : JavaCodecUtil.iterateAsTag(worldGen)) {
            String javaIdentifier = ((StringTag)biomeTag.get("name")).getValue();
            int bedrockId = ((Object2IntMap)Registries.BIOME_IDENTIFIERS.get()).getOrDefault((Object)javaIdentifier, 0);
            int javaId = ((IntTag)biomeTag.get("id")).getValue();
            if (javaId > greatestBiomeId) {
                greatestBiomeId = javaId;
            }
            biomeTranslations.put(javaId, bedrockId);
            if (javaId != 0) continue;
            biomeTranslations.defaultReturnValue(bedrockId);
        }
        int[] biomes = new int[greatestBiomeId + 1];
        for (Int2IntMap.Entry entry : biomeTranslations.int2IntEntrySet()) {
            biomes[entry.getIntKey()] = entry.getIntValue();
        }
        session.setBiomeTranslations(biomes);
    }

    public static BlockStorage toNewBedrockBiome(GeyserSession session, DataPalette biomeData) {
        BlockStorage storage;
        int[] biomeTranslations = session.getBiomeTranslations();
        Palette palette = biomeData.getPalette();
        if (palette instanceof SingletonPalette) {
            int biomeId = biomeTranslations[palette.idToState(0)];
            return new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton(biomeId));
        }
        if (!(palette instanceof GlobalPalette)) {
            int i;
            BitStorage bitStorage = biomeData.getStorage();
            int size = palette.size();
            BitArray bitArray = BitArrayVersion.forBitsCeil(bitStorage.getBitsPerEntry()).createArray(4096);
            IntArrayList bedrockPalette = new IntArrayList(size);
            for (i = 0; i < size; ++i) {
                int javaId = palette.idToState(i);
                bedrockPalette.add(biomeTranslations[javaId]);
            }
            for (i = 0; i < 64; ++i) {
                int idx = bitStorage.get(i);
                int x = i & 3;
                int y = i >> 4 & 3;
                int z = i >> 2 & 3;
                BiomeTranslator.multiplyIdToStorage(bitArray, idx, x, y, z);
            }
            storage = new BlockStorage(bitArray, bedrockPalette);
        } else {
            storage = new BlockStorage(0);
            for (int i = 0; i < 64; ++i) {
                int javaId = palette.idToState(biomeData.getStorage().get(i));
                int x = i & 3;
                int y = i >> 4 & 3;
                int z = i >> 2 & 3;
                int biomeId = biomeTranslations[javaId];
                int idx = storage.idFor(biomeId);
                BiomeTranslator.multiplyIdToStorage(storage.getBitArray(), idx, x, y, z);
            }
        }
        return storage;
    }

    private static void multiplyIdToStorage(BitArray bitArray, int idx, int x, int y, int z) {
        for (int blockX = x << 2; blockX < (x << 2) + 4; ++blockX) {
            for (int blockZ = z << 2; blockZ < (z << 2) + 4; ++blockZ) {
                for (int blockY = y << 2; blockY < (y << 2) + 4; ++blockY) {
                    bitArray.set(blockX << 8 | blockZ << 4 | blockY, idx);
                }
            }
        }
    }
}

