/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="_door$", usesParams=true, passDefaultBoxes=true)
public class DoorCollision
extends BlockCollision {
    private int facing;

    public DoorCollision(String params, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        if (params.contains("facing=north")) {
            this.facing = 1;
        } else if (params.contains("facing=east")) {
            this.facing = 2;
        } else if (params.contains("facing=south")) {
            this.facing = 3;
        } else if (params.contains("facing=west")) {
            this.facing = 4;
        }
        if (params.contains("open=true")) {
            this.facing = this.facing % 2 + 1;
        }
    }

    @Override
    public boolean correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        boolean result = super.correctPosition(session, x, y, z, playerCollision);
        playerCollision.setSizeX(playerCollision.getSizeX() - 1.0E-4);
        playerCollision.setSizeY(playerCollision.getSizeY() - 1.0E-4);
        playerCollision.setSizeZ(playerCollision.getSizeZ() - 1.0E-4);
        if (this.checkIntersection(x, y, z, playerCollision)) {
            switch (this.facing) {
                case 1: {
                    playerCollision.setMiddleZ((double)z + 0.5125);
                    break;
                }
                case 2: {
                    playerCollision.setMiddleX((double)x + 0.5125);
                    break;
                }
                case 3: {
                    playerCollision.setMiddleZ((double)z + 0.4875);
                    break;
                }
                case 4: {
                    playerCollision.setMiddleX((double)x + 0.4875);
                }
            }
        }
        playerCollision.setSizeX(playerCollision.getSizeX() + 1.0E-4);
        playerCollision.setSizeY(playerCollision.getSizeY() + 1.0E-4);
        playerCollision.setSizeZ(playerCollision.getSizeZ() + 1.0E-4);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoorCollision)) {
            return false;
        }
        DoorCollision other = (DoorCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.facing == other.facing;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoorCollision;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.facing;
        return result;
    }
}

