/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.AssetUtils;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class MinecraftLocale {
    public static final Map<String, Map<String, String>> LOCALE_MAPPINGS = new HashMap<String, Map<String, String>>();
    private static final Path LOCALE_FOLDER = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("locales");

    public static void ensureEN_US() {
        Path localeFile = MinecraftLocale.getPath("en_us");
        AssetUtils.addTask(!Files.exists(localeFile, new LinkOption[0]), new AssetUtils.ClientJarTask("assets/minecraft/lang/en_us.json", stream -> AssetUtils.saveFile(localeFile, stream), () -> {
            if ("en_us".equals(GeyserLocale.getDefaultLocale())) {
                MinecraftLocale.loadLocale("en_us");
            }
        }));
    }

    public static void downloadAndLoadLocale(String locale) {
        if (MinecraftLocale.isLocaleLoaded(locale = locale.toLowerCase(Locale.ROOT))) {
            GeyserImpl.getInstance().getLogger().debug("Locale already loaded: " + locale);
            return;
        }
        if (locale.equals("nb_no")) {
            locale = "no_no";
        }
        if (!AssetUtils.isAssetKnown("minecraft/lang/" + locale + ".json") && !locale.equals("en_us")) {
            if (MinecraftLocale.loadLocale(locale)) {
                GeyserImpl.getInstance().getLogger().debug("Loaded locale locally while not being in asset map: " + locale);
            } else {
                GeyserImpl.getInstance().getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.locale.fail.invalid", locale));
            }
            return;
        }
        GeyserImpl.getInstance().getLogger().debug("Downloading and loading locale: " + locale);
        MinecraftLocale.downloadLocale(locale);
        if (!MinecraftLocale.loadLocale(locale)) {
            GeyserImpl.getInstance().getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.locale.fail.missing", locale));
        }
    }

    private static void downloadLocale(String locale) {
        if (locale.equals("en_us")) {
            return;
        }
        Path localeFile = MinecraftLocale.getPath(locale);
        if (Files.exists(localeFile, new LinkOption[0])) {
            String targetHash;
            String curHash = MinecraftLocale.byteArrayToHexString(FileUtils.calculateSHA1(localeFile));
            if (!curHash.equals(targetHash = AssetUtils.getAsset("minecraft/lang/" + locale + ".json").getHash())) {
                GeyserImpl.getInstance().getLogger().debug("Locale out of date; re-downloading: " + locale);
            } else {
                GeyserImpl.getInstance().getLogger().debug("Locale already downloaded and up-to date: " + locale);
                return;
            }
        }
        try {
            String hash = AssetUtils.getAsset("minecraft/lang/" + locale + ".json").getHash();
            WebUtils.downloadFile("https://resources.download.minecraft.net/" + hash.substring(0, 2) + "/" + hash, localeFile.toString());
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Unable to download locale file hash", e);
        }
    }

    private static Path getPath(String locale) {
        return LOCALE_FOLDER.resolve(locale + ".json");
    }

    private static boolean loadLocale(String locale) {
        String lowercaseLocale = locale.toLowerCase(Locale.ROOT);
        Path localeFile = MinecraftLocale.getPath(lowercaseLocale);
        Path localeOverride = MinecraftLocale.getPath("overrides/" + lowercaseLocale);
        if (lowercaseLocale.equals("no_no")) {
            lowercaseLocale = "nb_no";
        }
        HashMap<String, String> langMap = new HashMap<String, String>();
        if (Files.exists(localeFile, new LinkOption[0]) && Files.isReadable(localeFile)) {
            langMap.putAll(MinecraftLocale.parseLangFile(localeFile, lowercaseLocale));
        }
        if (Files.exists(localeOverride, new LinkOption[0]) && Files.isReadable(localeOverride)) {
            langMap.putAll(MinecraftLocale.parseLangFile(localeOverride, lowercaseLocale));
        }
        if (!langMap.isEmpty()) {
            LOCALE_MAPPINGS.put(lowercaseLocale, langMap);
            return true;
        }
        return false;
    }

    public static Map<String, String> parseLangFile(Path localeFile, String locale) {
        HashMap<String, String> hashMap;
        block10: {
            InputStream localeStream = Files.newInputStream(localeFile, StandardOpenOption.READ);
            try {
                JsonNode localeObj = GeyserImpl.JSON_MAPPER.readTree(localeStream);
                Iterator<Map.Entry<String, JsonNode>> localeIterator = localeObj.fields();
                HashMap<String, String> langMap = new HashMap<String, String>();
                while (localeIterator.hasNext()) {
                    Map.Entry<String, JsonNode> entry = localeIterator.next();
                    langMap.put(entry.getKey(), entry.getValue().asText());
                }
                hashMap = langMap;
                if (localeStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (localeStream != null) {
                        try {
                            localeStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new AssertionError((Object)GeyserLocale.getLocaleStringLog("geyser.locale.fail.file", locale, e.getMessage()));
                }
                catch (Exception e) {
                    throw new AssertionError(GeyserLocale.getLocaleStringLog("geyser.locale.fail.json", locale), e);
                }
            }
            localeStream.close();
        }
        return hashMap;
    }

    public static String getLocaleString(String messageText, String locale) {
        Map<String, String> localeStrings = LOCALE_MAPPINGS.get(locale.toLowerCase(Locale.ROOT));
        if (localeStrings == null && (localeStrings = LOCALE_MAPPINGS.get(GeyserLocale.getDefaultLocale())) == null) {
            GeyserImpl.getInstance().getLogger().debug("MISSING DEFAULT LOCALE: " + GeyserLocale.getDefaultLocale());
            return messageText;
        }
        return localeStrings.getOrDefault(messageText, messageText);
    }

    public static @Nullable String getLocaleStringIfPresent(String messageText, String locale) {
        Map<String, String> localeStrings = LOCALE_MAPPINGS.get(locale.toLowerCase(Locale.ROOT));
        if (localeStrings != null) {
            return localeStrings.get(messageText);
        }
        return null;
    }

    public static boolean isLocaleLoaded(String locale) {
        return LOCALE_MAPPINGS.containsKey(locale.toLowerCase(Locale.ROOT));
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (byte value : b) {
            result.append(Integer.toString((value & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    static {
        try {
            Files.createDirectories(LOCALE_FOLDER, new FileAttribute[0]);
            Files.createDirectories(LOCALE_FOLDER.resolve("overrides"), new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException("Unable to create locale folders! " + exception.getMessage());
        }
    }
}

