/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;

public class FakeHeadProvider {
    private static final LoadingCache<FakeHeadEntry, SkinProvider.SkinData> MERGED_SKINS_LOADING_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(10000L).build((CacheLoader)new CacheLoader<FakeHeadEntry, SkinProvider.SkinData>(){

        public SkinProvider.SkinData load(@NonNull FakeHeadEntry fakeHeadEntry) throws Exception {
            SkinProvider.SkinData skinData = SkinProvider.getOrDefault(SkinProvider.requestSkinData(fakeHeadEntry.getEntity()), null, 5);
            if (skinData == null) {
                throw new Exception("Couldn't load player's original skin");
            }
            SkinProvider.Skin skin = skinData.skin();
            SkinProvider.Cape cape = skinData.cape();
            SkinProvider.SkinGeometry geometry = skinData.geometry().geometryName().equals("{\"geometry\" :{\"default\" :\"geometry.humanoid.customSlim\"}}") ? SkinProvider.WEARING_CUSTOM_SKULL_SLIM : SkinProvider.WEARING_CUSTOM_SKULL;
            SkinProvider.Skin headSkin = SkinProvider.getOrDefault(SkinProvider.requestSkin(fakeHeadEntry.getEntity().getUuid(), fakeHeadEntry.getFakeHeadSkinUrl(), false), SkinProvider.EMPTY_SKIN, 5);
            BufferedImage originalSkinImage = SkinProvider.imageDataToBufferedImage(skin.getSkinData(), 64, skin.getSkinData().length / 4 / 64);
            BufferedImage headSkinImage = SkinProvider.imageDataToBufferedImage(headSkin.getSkinData(), 64, headSkin.getSkinData().length / 4 / 64);
            Graphics2D graphics2D = originalSkinImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, 64, 16);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawImage(headSkinImage, 0, 0, 64, 16, 0, 0, 64, 16, null);
            graphics2D.dispose();
            String skinKey = "customPlayerHead_" + fakeHeadEntry.getFakeHeadSkinUrl() + "_" + skin.getTextureUrl();
            byte[] targetSkinData = SkinProvider.bufferedImageToImageData(originalSkinImage);
            SkinProvider.Skin mergedSkin = new SkinProvider.Skin(fakeHeadEntry.getEntity().getUuid(), skinKey, targetSkinData, System.currentTimeMillis(), false, false);
            fakeHeadEntry.setEntity(null);
            return new SkinProvider.SkinData(mergedSkin, cape, geometry);
        }
    });

    public static void setHead(GeyserSession session, PlayerEntity entity, Tag skullOwner) {
        if (skullOwner == null) {
            return;
        }
        if (skullOwner instanceof CompoundTag) {
            CompoundTag profileTag = (CompoundTag)skullOwner;
            SkinManager.GameProfileData gameProfileData = SkinManager.GameProfileData.from(profileTag);
            if (gameProfileData == null) {
                return;
            }
            FakeHeadProvider.loadHead(session, entity, gameProfileData);
        } else if (skullOwner instanceof StringTag) {
            StringTag ownerTag = (StringTag)skullOwner;
            String owner = ownerTag.getValue();
            if (owner.isEmpty()) {
                return;
            }
            CompletableFuture<String> completableFuture = SkinProvider.requestTexturesFromUsername(owner);
            completableFuture.whenCompleteAsync((encodedJson, throwable) -> {
                if (throwable != null) {
                    GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), (Throwable)throwable);
                    return;
                }
                try {
                    SkinManager.GameProfileData gameProfileData = SkinManager.GameProfileData.loadFromJson(encodedJson);
                    if (gameProfileData == null) {
                        return;
                    }
                    FakeHeadProvider.loadHead(session, entity, gameProfileData);
                }
                catch (IOException e) {
                    GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid(), e.getMessage()));
                }
            });
        }
    }

    public static void loadHead(GeyserSession session, PlayerEntity entity, SkinManager.GameProfileData gameProfileData) {
        String fakeHeadSkinUrl = gameProfileData.skinUrl();
        session.getPlayerWithCustomHeads().add(entity.getUuid());
        String texturesProperty = entity.getTexturesProperty();
        SkinProvider.getExecutorService().execute(() -> {
            try {
                SkinProvider.SkinData mergedSkinData = (SkinProvider.SkinData)MERGED_SKINS_LOADING_CACHE.get((Object)new FakeHeadEntry(texturesProperty, fakeHeadSkinUrl, entity));
                SkinManager.sendSkinPacket(session, entity, mergedSkinData);
            }
            catch (ExecutionException e) {
                GeyserImpl.getInstance().getLogger().error("Couldn't merge skin of " + entity.getUsername() + " with head skin url " + fakeHeadSkinUrl, e);
            }
        });
    }

    public static void restoreOriginalSkin(GeyserSession session, LivingEntity livingEntity) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity entity = (PlayerEntity)livingEntity;
        if (!session.getPlayerWithCustomHeads().remove(entity.getUuid())) {
            return;
        }
        SkinProvider.requestSkinData(entity).whenCompleteAsync((skinData, throwable) -> {
            if (throwable != null) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), (Throwable)throwable);
                return;
            }
            SkinManager.sendSkinPacket(session, entity, skinData);
        });
    }

    private static class FakeHeadEntry {
        private final String texturesProperty;
        private final String fakeHeadSkinUrl;
        private PlayerEntity entity;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FakeHeadEntry that = (FakeHeadEntry)o;
            return Objects.equals(this.texturesProperty, that.texturesProperty) && Objects.equals(this.fakeHeadSkinUrl, that.fakeHeadSkinUrl);
        }

        public int hashCode() {
            return Objects.hash(this.texturesProperty, this.fakeHeadSkinUrl);
        }

        public FakeHeadEntry(String texturesProperty, String fakeHeadSkinUrl, PlayerEntity entity) {
            this.texturesProperty = texturesProperty;
            this.fakeHeadSkinUrl = fakeHeadSkinUrl;
            this.entity = entity;
        }

        public String getTexturesProperty() {
            return this.texturesProperty;
        }

        public String getFakeHeadSkinUrl() {
            return this.fakeHeadSkinUrl;
        }

        public PlayerEntity getEntity() {
            return this.entity;
        }

        public void setEntity(PlayerEntity entity) {
            this.entity = entity;
        }
    }
}

