/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import org.cloudburstmc.math.vector.Vector3d;

public class TeleportCache {
    private static final double ERROR_X_AND_Z = 0.1;
    private static final double ERROR_Y = 0.1;
    private static final int RESEND_THRESHOLD = 5;
    private final double x;
    private final double y;
    private final double z;
    private final float pitch;
    private final float yaw;
    private final int teleportConfirmId;
    private int unconfirmedFor = 0;

    public boolean canConfirm(Vector3d position) {
        return Math.abs(this.x - position.getX()) < 0.1 && Math.abs(this.y - position.getY()) < 0.1 && Math.abs(this.z - position.getZ()) < 0.1;
    }

    public void incrementUnconfirmedFor() {
        ++this.unconfirmedFor;
    }

    public void resetUnconfirmedFor() {
        this.unconfirmedFor = 0;
    }

    public boolean shouldResend() {
        return this.unconfirmedFor >= 5;
    }

    public TeleportCache(double x, double y, double z, float pitch, float yaw, int teleportConfirmId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
        this.teleportConfirmId = teleportConfirmId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public int getTeleportConfirmId() {
        return this.teleportConfirmId;
    }

    public int getUnconfirmedFor() {
        return this.unconfirmedFor;
    }

    public void setUnconfirmedFor(int unconfirmedFor) {
        this.unconfirmedFor = unconfirmedFor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeleportCache)) {
            return false;
        }
        TeleportCache other = (TeleportCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (this.getTeleportConfirmId() != other.getTeleportConfirmId()) {
            return false;
        }
        return this.getUnconfirmedFor() == other.getUnconfirmedFor();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TeleportCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + this.getTeleportConfirmId();
        result = result * 59 + this.getUnconfirmedFor();
        return result;
    }

    public String toString() {
        return "TeleportCache(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", pitch=" + this.getPitch() + ", yaw=" + this.getYaw() + ", teleportConfirmId=" + this.getTeleportConfirmId() + ", unconfirmedFor=" + this.getUnconfirmedFor() + ")";
    }
}

