/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.scoreboard.UpdateType;

public final class Score {
    private final long id;
    private final String name;
    private ScoreInfo cachedInfo;
    private final ScoreData currentData;
    private ScoreData cachedData;

    public Score(long id, String name) {
        this.id = id;
        this.name = name;
        this.currentData = new ScoreData();
    }

    public String getDisplayName() {
        Team team = this.cachedData.team;
        if (team != null) {
            return team.getDisplayName(this.name);
        }
        return this.name;
    }

    public int getScore() {
        return this.currentData.getScore();
    }

    public Score setScore(int score) {
        this.currentData.score = score;
        return this;
    }

    public Team getTeam() {
        return this.currentData.team;
    }

    public Score setTeam(Team team) {
        if (this.currentData.team != null && team != null) {
            if (!this.currentData.team.equals(team)) {
                this.currentData.team = team;
                this.setUpdateType(UpdateType.UPDATE);
            }
            return this;
        }
        if (this.currentData.team != null || team != null) {
            this.currentData.team = team;
            this.setUpdateType(UpdateType.UPDATE);
        }
        return this;
    }

    public UpdateType getUpdateType() {
        return this.currentData.updateType;
    }

    public Score setUpdateType(UpdateType updateType) {
        if (updateType != UpdateType.NOTHING) {
            this.currentData.changed = true;
        }
        this.currentData.updateType = updateType;
        return this;
    }

    public boolean shouldUpdate() {
        return this.cachedData == null || this.currentData.changed || this.currentData.team != null && this.currentData.team.shouldUpdate();
    }

    public void update(String objectiveName) {
        if (this.cachedData == null) {
            this.cachedData = new ScoreData();
            this.cachedData.updateType = UpdateType.ADD;
            if (this.currentData.updateType == UpdateType.REMOVE) {
                this.cachedData.updateType = UpdateType.REMOVE;
            }
        } else {
            this.cachedData.updateType = this.currentData.updateType;
        }
        this.currentData.changed = false;
        this.cachedData.team = this.currentData.team;
        this.cachedData.score = this.currentData.score;
        String name = this.name;
        if (this.cachedData.team != null) {
            this.cachedData.team.prepareUpdate();
            name = this.cachedData.team.getDisplayName(name);
        }
        this.cachedInfo = new ScoreInfo(this.id, objectiveName, this.cachedData.score, name);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ScoreInfo getCachedInfo() {
        return this.cachedInfo;
    }

    public ScoreData getCurrentData() {
        return this.currentData;
    }

    public ScoreData getCachedData() {
        return this.cachedData;
    }

    public static final class ScoreData {
        private UpdateType updateType = UpdateType.ADD;
        private boolean changed;
        private Team team;
        private int score;

        private ScoreData() {
        }

        public UpdateType getUpdateType() {
            return this.updateType;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public Team getTeam() {
            return this.team;
        }

        public int getScore() {
            return this.score;
        }
    }
}

