/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.level.physics.PistonBehavior;
import org.geysermc.geyser.util.BlockUtils;

public final class BlockMapping {
    public static BlockMapping DEFAULT = BlockMapping.builder().javaIdentifier("minecraft:air").pistonBehavior(PistonBehavior.NORMAL).build();
    private final String javaIdentifier;
    private final int javaBlockId;
    private final float hardness;
    private final boolean canBreakWithHand;
    private final int collisionIndex;
    private final @Nullable String pickItem;
    private final @NonNull PistonBehavior pistonBehavior;
    private final boolean isBlockEntity;
    private final boolean isNonVanilla;

    public String getCleanJavaIdentifier() {
        return BlockUtils.getCleanIdentifier(this.javaIdentifier);
    }

    public String getItemIdentifier() {
        if (this.pickItem != null && !this.pickItem.equals("minecraft:air")) {
            return this.pickItem;
        }
        return this.getCleanJavaIdentifier();
    }

    public String getPickItem() {
        if (this.pickItem != null) {
            return this.pickItem;
        }
        return this.getCleanJavaIdentifier();
    }

    BlockMapping(String javaIdentifier, int javaBlockId, float hardness, boolean canBreakWithHand, int collisionIndex, @Nullable String pickItem, @NonNull PistonBehavior pistonBehavior, boolean isBlockEntity, boolean isNonVanilla) {
        if (pistonBehavior == null) {
            throw new NullPointerException("pistonBehavior is marked non-null but is null");
        }
        this.javaIdentifier = javaIdentifier;
        this.javaBlockId = javaBlockId;
        this.hardness = hardness;
        this.canBreakWithHand = canBreakWithHand;
        this.collisionIndex = collisionIndex;
        this.pickItem = pickItem;
        this.pistonBehavior = pistonBehavior;
        this.isBlockEntity = isBlockEntity;
        this.isNonVanilla = isNonVanilla;
    }

    public static BlockMappingBuilder builder() {
        return new BlockMappingBuilder();
    }

    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    public int getJavaBlockId() {
        return this.javaBlockId;
    }

    public float getHardness() {
        return this.hardness;
    }

    public boolean isCanBreakWithHand() {
        return this.canBreakWithHand;
    }

    public int getCollisionIndex() {
        return this.collisionIndex;
    }

    public @NonNull PistonBehavior getPistonBehavior() {
        return this.pistonBehavior;
    }

    public boolean isBlockEntity() {
        return this.isBlockEntity;
    }

    public boolean isNonVanilla() {
        return this.isNonVanilla;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockMapping)) {
            return false;
        }
        BlockMapping other = (BlockMapping)o;
        if (this.getJavaBlockId() != other.getJavaBlockId()) {
            return false;
        }
        if (Float.compare(this.getHardness(), other.getHardness()) != 0) {
            return false;
        }
        if (this.isCanBreakWithHand() != other.isCanBreakWithHand()) {
            return false;
        }
        if (this.getCollisionIndex() != other.getCollisionIndex()) {
            return false;
        }
        if (this.isBlockEntity() != other.isBlockEntity()) {
            return false;
        }
        if (this.isNonVanilla() != other.isNonVanilla()) {
            return false;
        }
        String this$javaIdentifier = this.getJavaIdentifier();
        String other$javaIdentifier = other.getJavaIdentifier();
        if (this$javaIdentifier == null ? other$javaIdentifier != null : !this$javaIdentifier.equals(other$javaIdentifier)) {
            return false;
        }
        String this$pickItem = this.getPickItem();
        String other$pickItem = other.getPickItem();
        if (this$pickItem == null ? other$pickItem != null : !this$pickItem.equals(other$pickItem)) {
            return false;
        }
        PistonBehavior this$pistonBehavior = this.getPistonBehavior();
        PistonBehavior other$pistonBehavior = other.getPistonBehavior();
        return !(this$pistonBehavior == null ? other$pistonBehavior != null : !((Object)((Object)this$pistonBehavior)).equals((Object)other$pistonBehavior));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getJavaBlockId();
        result = result * 59 + Float.floatToIntBits(this.getHardness());
        result = result * 59 + (this.isCanBreakWithHand() ? 79 : 97);
        result = result * 59 + this.getCollisionIndex();
        result = result * 59 + (this.isBlockEntity() ? 79 : 97);
        result = result * 59 + (this.isNonVanilla() ? 79 : 97);
        String $javaIdentifier = this.getJavaIdentifier();
        result = result * 59 + ($javaIdentifier == null ? 43 : $javaIdentifier.hashCode());
        String $pickItem = this.getPickItem();
        result = result * 59 + ($pickItem == null ? 43 : $pickItem.hashCode());
        PistonBehavior $pistonBehavior = this.getPistonBehavior();
        result = result * 59 + ($pistonBehavior == null ? 43 : ((Object)((Object)$pistonBehavior)).hashCode());
        return result;
    }

    public String toString() {
        return "BlockMapping(javaIdentifier=" + this.getJavaIdentifier() + ", javaBlockId=" + this.getJavaBlockId() + ", hardness=" + this.getHardness() + ", canBreakWithHand=" + this.isCanBreakWithHand() + ", collisionIndex=" + this.getCollisionIndex() + ", pickItem=" + this.getPickItem() + ", pistonBehavior=" + this.getPistonBehavior() + ", isBlockEntity=" + this.isBlockEntity() + ", isNonVanilla=" + this.isNonVanilla() + ")";
    }

    public static class BlockMappingBuilder {
        private String javaIdentifier;
        private int javaBlockId;
        private float hardness;
        private boolean canBreakWithHand;
        private int collisionIndex;
        private String pickItem;
        private PistonBehavior pistonBehavior;
        private boolean isBlockEntity;
        private boolean isNonVanilla;

        BlockMappingBuilder() {
        }

        public BlockMappingBuilder javaIdentifier(String javaIdentifier) {
            this.javaIdentifier = javaIdentifier;
            return this;
        }

        public BlockMappingBuilder javaBlockId(int javaBlockId) {
            this.javaBlockId = javaBlockId;
            return this;
        }

        public BlockMappingBuilder hardness(float hardness) {
            this.hardness = hardness;
            return this;
        }

        public BlockMappingBuilder canBreakWithHand(boolean canBreakWithHand) {
            this.canBreakWithHand = canBreakWithHand;
            return this;
        }

        public BlockMappingBuilder collisionIndex(int collisionIndex) {
            this.collisionIndex = collisionIndex;
            return this;
        }

        public BlockMappingBuilder pickItem(@Nullable String pickItem) {
            this.pickItem = pickItem;
            return this;
        }

        public BlockMappingBuilder pistonBehavior(@NonNull PistonBehavior pistonBehavior) {
            this.pistonBehavior = pistonBehavior;
            return this;
        }

        public BlockMappingBuilder isBlockEntity(boolean isBlockEntity) {
            this.isBlockEntity = isBlockEntity;
            return this;
        }

        public BlockMappingBuilder isNonVanilla(boolean isNonVanilla) {
            this.isNonVanilla = isNonVanilla;
            return this;
        }

        public BlockMapping build() {
            return new BlockMapping(this.javaIdentifier, this.javaBlockId, this.hardness, this.canBreakWithHand, this.collisionIndex, this.pickItem, this.pistonBehavior, this.isBlockEntity, this.isNonVanilla);
        }

        public String toString() {
            return "BlockMapping.BlockMappingBuilder(javaIdentifier=" + this.javaIdentifier + ", javaBlockId=" + this.javaBlockId + ", hardness=" + this.hardness + ", canBreakWithHand=" + this.canBreakWithHand + ", collisionIndex=" + this.collisionIndex + ", pickItem=" + this.pickItem + ", pistonBehavior=" + this.pistonBehavior + ", isBlockEntity=" + this.isBlockEntity + ", isNonVanilla=" + this.isNonVanilla + ")";
        }
    }
}

