/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.fabric.world;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityInfo;
import com.github.steveice10.opennbt.tag.builtin.ByteArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.DoubleTag;
import com.github.steveice10.opennbt.tag.builtin.FloatTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.LongArrayTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_2338;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3222;
import net.minecraft.class_3722;
import net.minecraft.class_5627;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.erosion.util.LecternUtils;
import org.geysermc.geyser.level.GeyserWorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.BlockEntityUtils;

public class GeyserFabricWorldManager
extends GeyserWorldManager {
    private final MinecraftServer server;

    public GeyserFabricWorldManager(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public boolean shouldExpectLecternHandled(GeyserSession session) {
        return true;
    }

    @Override
    public void sendLecternData(GeyserSession session, int x, int z, List<BlockEntityInfo> blockEntityInfos) {
        this.server.execute(() -> {
            class_3222 player = this.getPlayer(session);
            if (player == null) {
                return;
            }
            class_2818 chunk = player.method_37908().method_8497(x, z);
            int chunkBlockX = x << 4;
            int chunkBlockZ = z << 4;
            for (int i = 0; i < blockEntityInfos.size(); ++i) {
                BlockEntityInfo blockEntityInfo = (BlockEntityInfo)blockEntityInfos.get(i);
                class_2586 blockEntity = chunk.method_8321(new class_2338(chunkBlockX + blockEntityInfo.getX(), blockEntityInfo.getY(), chunkBlockZ + blockEntityInfo.getZ()));
                this.sendLecternData(session, blockEntity, true);
            }
        });
    }

    @Override
    public void sendLecternData(GeyserSession session, int x, int y, int z) {
        this.server.execute(() -> {
            class_3222 player = this.getPlayer(session);
            if (player == null) {
                return;
            }
            class_2586 blockEntity = player.method_37908().method_8321(new class_2338(x, y, z));
            this.sendLecternData(session, blockEntity, false);
        });
    }

    private void sendLecternData(GeyserSession session, class_2586 blockEntity, boolean isChunkLoad) {
        if (!(blockEntity instanceof class_3722)) {
            return;
        }
        class_3722 lectern = (class_3722)blockEntity;
        int x = blockEntity.method_11016().method_10263();
        int y = blockEntity.method_11016().method_10264();
        int z = blockEntity.method_11016().method_10260();
        if (!lectern.method_17522()) {
            if (!isChunkLoad) {
                BlockEntityUtils.updateBlockEntity(session, LecternUtils.getBaseLecternTag(x, y, z, 0).build(), Vector3i.from(x, y, z));
            }
            return;
        }
        class_1799 book = lectern.method_17520();
        int pageCount = class_1843.method_17443((class_1799)book);
        boolean hasBookPages = pageCount > 0;
        NbtMapBuilder lecternTag = LecternUtils.getBaseLecternTag(x, y, z, hasBookPages ? pageCount : 1);
        lecternTag.putInt("page", lectern.method_17523() / 2);
        NbtMapBuilder bookTag = NbtMap.builder().putByte("Count", (byte)book.method_7947()).putShort("Damage", (short)0).putString("Name", "minecraft:writable_book");
        ArrayList<NbtMap> pages = new ArrayList<NbtMap>(hasBookPages ? pageCount : 1);
        if (hasBookPages && class_1840.method_8047((class_2487)book.method_7969())) {
            class_2499 listTag = book.method_7969().method_10554("pages", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                String page = listTag.method_10608(i);
                NbtMapBuilder pageBuilder = NbtMap.builder().putString("photoname", "").putString("text", page);
                pages.add(pageBuilder.build());
            }
        } else {
            NbtMapBuilder pageBuilder = NbtMap.builder().putString("photoname", "").putString("text", "");
            pages.add(pageBuilder.build());
        }
        bookTag.putCompound("tag", NbtMap.builder().putList("pages", NbtType.COMPOUND, pages).build());
        lecternTag.putCompound("book", bookTag.build());
        NbtMap blockEntityTag = lecternTag.build();
        BlockEntityUtils.updateBlockEntity(session, blockEntityTag, Vector3i.from(x, y, z));
    }

    @Override
    public boolean hasPermission(GeyserSession session, String permission) {
        class_3222 player = this.getPlayer(session);
        return Permissions.check((class_1297)player, (String)permission);
    }

    @Override
    public GameMode getDefaultGameMode(GeyserSession session) {
        return GameMode.byId(this.server.method_3790().method_8379());
    }

    @Override
    public @NonNull CompletableFuture<CompoundTag> getPickItemNbt(GeyserSession session, int x, int y, int z, boolean addNbtData) {
        CompletableFuture<CompoundTag> future = new CompletableFuture<CompoundTag>();
        this.server.execute(() -> {
            class_3222 player = this.getPlayer(session);
            if (player == null) {
                future.complete(null);
                return;
            }
            class_2338 pos = new class_2338(x, y, z);
            class_2586 blockEntity = player.method_37908().method_8500(pos).method_8321(pos);
            if (blockEntity instanceof class_2573) {
                class_2573 banner = (class_2573)blockEntity;
                class_1799 itemStack = banner.method_10907();
                CompoundTag tag = OpenNbtTagVisitor.convert("", itemStack.method_7948());
                future.complete(tag);
                return;
            }
            future.complete(null);
        });
        return future;
    }

    private class_3222 getPlayer(GeyserSession session) {
        return this.server.method_3760().method_14602(session.getPlayerEntity().getUuid());
    }

    private static class OpenNbtTagVisitor
    implements class_5627 {
        private String currentKey;
        private final CompoundTag root;
        private Tag currentTag;

        OpenNbtTagVisitor(String key) {
            this.root = new CompoundTag(key);
        }

        public void method_32302(class_2519 stringTag) {
            this.currentTag = new StringTag(this.currentKey, stringTag.method_10714());
        }

        public void method_32291(class_2481 byteTag) {
            this.currentTag = new ByteTag(this.currentKey, byteTag.method_10698());
        }

        public void method_32301(class_2516 shortTag) {
            this.currentTag = new ShortTag(this.currentKey, shortTag.method_10696());
        }

        public void method_32297(class_2497 intTag) {
            this.currentTag = new IntTag(this.currentKey, intTag.method_10701());
        }

        public void method_32300(class_2503 longTag) {
            this.currentTag = new LongTag(this.currentKey, longTag.method_10699());
        }

        public void method_32295(class_2494 floatTag) {
            this.currentTag = new FloatTag(this.currentKey, floatTag.method_10700());
        }

        public void method_32293(class_2489 doubleTag) {
            this.currentTag = new DoubleTag(this.currentKey, doubleTag.method_10697());
        }

        public void method_32290(class_2479 byteArrayTag) {
            this.currentTag = new ByteArrayTag(this.currentKey, byteArrayTag.method_10521());
        }

        public void method_32296(class_2495 intArrayTag) {
            this.currentTag = new IntArrayTag(this.currentKey, intArrayTag.method_10588());
        }

        public void method_32299(class_2501 longArrayTag) {
            this.currentTag = new LongArrayTag(this.currentKey, longArrayTag.method_10615());
        }

        public void method_32298(class_2499 listTag) {
            ListTag newList = new ListTag(this.currentKey);
            for (class_2520 tag : listTag) {
                this.currentKey = "";
                tag.method_32289((class_5627)this);
                newList.add(this.currentTag);
            }
            this.currentTag = newList;
        }

        public void method_32292(@NonNull class_2487 compoundTag) {
            this.currentTag = OpenNbtTagVisitor.convert(this.currentKey, compoundTag);
        }

        private static CompoundTag convert(String name, class_2487 compoundTag) {
            OpenNbtTagVisitor visitor = new OpenNbtTagVisitor(name);
            Iterator iterator = compoundTag.method_10541().iterator();
            while (iterator.hasNext()) {
                String key;
                visitor.currentKey = key = (String)iterator.next();
                class_2520 tag = Objects.requireNonNull(compoundTag.method_10580(key));
                tag.method_32289((class_5627)visitor);
                visitor.root.put(visitor.currentTag);
            }
            return visitor.root;
        }

        public void method_32294(@NonNull class_2491 endTag) {
        }
    }
}

