/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.physics;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.level.physics.Axis;

public enum Direction {
    DOWN(1, Vector3i.from(0, -1, 0), Axis.Y, com.github.steveice10.mc.protocol.data.game.entity.object.Direction.DOWN),
    UP(0, Vector3i.UNIT_Y, Axis.Y, com.github.steveice10.mc.protocol.data.game.entity.object.Direction.UP),
    NORTH(3, Vector3i.from(0, 0, -1), Axis.Z, com.github.steveice10.mc.protocol.data.game.entity.object.Direction.NORTH),
    SOUTH(2, Vector3i.UNIT_Z, Axis.Z, com.github.steveice10.mc.protocol.data.game.entity.object.Direction.SOUTH),
    WEST(5, Vector3i.from(-1, 0, 0), Axis.X, com.github.steveice10.mc.protocol.data.game.entity.object.Direction.WEST),
    EAST(4, Vector3i.UNIT_X, Axis.X, com.github.steveice10.mc.protocol.data.game.entity.object.Direction.EAST);

    public static final Direction[] VALUES;
    private final int reversedId;
    private final Vector3i unitVector;
    private final Axis axis;
    private final com.github.steveice10.mc.protocol.data.game.entity.object.Direction pistonValue;

    private Direction(int reversedId, Vector3i unitVector, Axis axis, com.github.steveice10.mc.protocol.data.game.entity.object.Direction pistonValue) {
        this.reversedId = reversedId;
        this.unitVector = unitVector;
        this.axis = axis;
        this.pistonValue = pistonValue;
    }

    public Direction reversed() {
        return VALUES[this.reversedId];
    }

    public boolean isVertical() {
        return this.axis == Axis.Y;
    }

    public boolean isHorizontal() {
        return this.axis == Axis.X || this.axis == Axis.Z;
    }

    public static @NonNull Direction fromPistonValue(com.github.steveice10.mc.protocol.data.game.entity.object.Direction pistonValue) {
        for (Direction direction : VALUES) {
            if (direction.pistonValue != pistonValue) continue;
            return direction;
        }
        throw new IllegalStateException();
    }

    public Vector3i getUnitVector() {
        return this.unitVector;
    }

    public Axis getAxis() {
        return this.axis;
    }

    static {
        VALUES = Direction.values();
    }
}

