/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityInfo;
import com.github.steveice10.mc.protocol.data.game.setting.Difficulty;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.level.GameRule;
import org.geysermc.geyser.session.GeyserSession;

public abstract class WorldManager {
    public final int getBlockAt(GeyserSession session, Vector3i vector) {
        return this.getBlockAt(session, vector.getX(), vector.getY(), vector.getZ());
    }

    public abstract int getBlockAt(GeyserSession var1, int var2, int var3, int var4);

    public final CompletableFuture<Integer> getBlockAtAsync(GeyserSession session, Vector3i vector) {
        return this.getBlockAtAsync(session, vector.getX(), vector.getY(), vector.getZ());
    }

    public CompletableFuture<Integer> getBlockAtAsync(GeyserSession session, int x, int y, int z) {
        return CompletableFuture.completedFuture(this.getBlockAt(session, x, y, z));
    }

    public int[] getBlocksAt(GeyserSession session, BlockPositionIterator iter) {
        int[] blocks = new int[iter.getMaxIterations()];
        while (iter.hasNext()) {
            int networkId;
            blocks[iter.getIteration()] = networkId = this.getBlockAt(session, iter.getX(), iter.getY(), iter.getZ());
            iter.next();
        }
        return blocks;
    }

    public abstract boolean hasOwnChunkCache();

    public abstract void sendLecternData(GeyserSession var1, int var2, int var3, int var4);

    public abstract void sendLecternData(GeyserSession var1, int var2, int var3, List<BlockEntityInfo> var4);

    public abstract boolean shouldExpectLecternHandled(GeyserSession var1);

    public void setGameRule(GeyserSession session, String name, Object value) {
        session.sendCommand("gamerule " + name + " " + value);
    }

    public abstract boolean getGameRuleBool(GeyserSession var1, GameRule var2);

    public abstract int getGameRuleInt(GeyserSession var1, GameRule var2);

    public void setPlayerGameMode(GeyserSession session, GameMode gameMode) {
        session.sendCommand("gamemode " + gameMode.name().toLowerCase(Locale.ROOT));
    }

    public abstract GameMode getDefaultGameMode(GeyserSession var1);

    public void setDefaultGameMode(GeyserSession session, GameMode gameMode) {
        session.sendCommand("defaultgamemode " + gameMode.name().toLowerCase(Locale.ROOT));
    }

    public void setDifficulty(GeyserSession session, Difficulty difficulty) {
        session.sendCommand("difficulty " + difficulty.name().toLowerCase(Locale.ROOT));
    }

    public abstract boolean hasPermission(GeyserSession var1, String var2);

    public String @Nullable [] getBiomeIdentifiers(boolean withTags) {
        return null;
    }

    public @NonNull CompletableFuture<@Nullable CompoundTag> getPickItemNbt(GeyserSession session, int x, int y, int z, boolean addNbtData) {
        return CompletableFuture.completedFuture(null);
    }
}

